/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core;

import net.wordrider.utilities.Consts;
import net.wordrider.utilities.LogUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.logging.Logger;

/**
 * @author Vity
 */
final class OneInstanceClient {
    private final static Logger logger = Logger.getLogger(OneInstanceClient.class.getName());

    private OneInstanceClient() {
    }

    public static boolean checkInstance(final Collection<String> openFiles) {
        if (!AppPrefs.getProperty(AppPrefs.ONEINSTANCE, false))
            return false;
        Socket clientSocket = null;
        try {
            logger.info("Testing existing instance");
            clientSocket = new Socket("localhost", Consts.ONE_INSTANCE_SERVER_PORT);
            if (openFiles != null && !openFiles.isEmpty()) {
                OutputStream out = null;
                try {
                    out = clientSocket.getOutputStream();
                    if (out != null) {
                        for (String file : openFiles) {
                            out.write(file.getBytes());
                            out.write('\n');
                        }
                        out.close();
                    }
                } catch (IOException e) {
                    LogUtils.processException(logger, e);
                    if (out != null) {
                        try {
                            out.close();
                        } catch (Exception ex) {
                            LogUtils.processException(logger, ex);
                        }
                    }
                }
            }
            logger.info("Application is already running. Exiting");
            return true;
        } catch (IOException e) {
            logger.info("No other instance is running.");
            final OneInstanceServer server = new OneInstanceServer();
            server.start();
        } finally {
            if (clientSocket != null)
                try {
                    clientSocket.close();
                } catch (IOException e) {
                    LogUtils.processException(logger, e);
                }
        }
        return false;
    }

}
