/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;

import javax.swing.text.Document;
import java.awt.*;
import java.io.File;
import java.util.logging.Logger;

/**
 * @author Vity
 */
abstract class AbstractFileProcessor implements FileProcessor {
    final static Logger logger = Logger.getLogger(AbstractFileProcessor.class.getName());
    private final File file;

    public AbstractFileProcessor(File file) {
        this.file = file;
    }


    public boolean process() {
        AppPrefs.storeProperty(AppPrefs.LASTOPENFOLDER_KEY, getFile().getAbsolutePath());
        return false;
    }

    File getFile() {
        return file;
    }

    boolean loadDocument(RiderArea area, DocumentProducer producer) {
        final RiderSwingWorker worker = new LoadFileAction(producer);
        worker.init();

        final Document result = (Document) worker.get();
        //final Document result = testDocument(area, file.getContent());
        if (result != null) {
            //area.repaint();
            area.setDocument(result);

            // temp.setDocument(new RiderDocument());
            area.setCursor(Cursor.getDefaultCursor());
            return true;
        } else return false;
    }

    Frame getMainFrame() {
        return MainApp.getInstance().getMainAppFrame();
    }        

}
