/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.swing;

import net.wordrider.utilities.Consts;

import javax.swing.*;
import java.util.Collection;
import java.util.Stack;

/**
 * @author Vity
 */
public final class RecentsComboModel extends DefaultComboBoxModel {

    private final Stack stack;

    public RecentsComboModel(final Stack v) {
        super(v);    //call to super
        this.stack = v;
    }

    public final void addElement(final Object anObject) {
        if (!anObject.equals("") && getIndexOf(anObject) < 0) {
            super.insertElementAt(anObject, 0);
            if (stack.size() > Consts.MAX_RECENT_PHRASES_COUNT) {
                this.remove(Consts.MAX_RECENT_PHRASES_COUNT - 1);
            }
        }
    }


    private void remove(int index) {
        setSelectedItem(getElementAt(0));
        stack.removeElementAt(index);
        fireIntervalRemoved(this, index, index);
    }

    public final Collection getList() {
        return stack;
    }
}
