/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures;

import javax.swing.*;

/**
 * @author Vity
 */
final class WidthSpinnerModel extends SpinnerNumberModel {

    public static Integer getNextHigh(int value, final int max) {
        value += 8 - (value % 8);
        if (max < value)
            value = max;
        return value;
    }

    public static int getNextHigh(int value) {
        value += 8 - (value % 8);
        return value;
    }

    private Integer getNextHigh(final Object nextHigh) {
        return getNextHigh(((Number) nextHigh).intValue(), ((Number) getMaximum()).intValue());
    }

    public final Object getNextValue() {
        return getNextHigh(getValue());
    }

    public final Object getPreviousValue() {
        int value = ((Number) getValue()).intValue();
        final Number min = ((Number) getMinimum());

        value -= 8 - (value % 8);
        if (min != null && min.intValue() > value)
            value = min.intValue();
        return value;
    }
}
