/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

import java.awt.image.RGBImageFilter;

/**
 * @author Vity
 */
public final class BrightnessFilter extends RGBImageFilter {

    private int brightness = 0;

    public BrightnessFilter() {
        this.canFilterIndexColorModel = true;
    }

    public final void setBrightness(final int brightness) {
        this.brightness = brightness;
    }

    public final int filterRGB(final int x, final int y, final int rgb) {
        // Get the individual colors
        int r = (rgb >> 16) & 0xff;
        int g = (rgb >> 8) & 0xff;
        int b = (rgb) & 0xff;

        // Calculate the brightness
        r += (brightness * r) / 100;
        g += (brightness * g) / 100;
        b += (brightness * b) / 100;

        // Check the boundaries
        r = Math.min(Math.max(0, r), 255);
        g = Math.min(Math.max(0, g), 255);
        b = Math.min(Math.max(0, b), 255);

        // Return the result
        return (rgb & 0xff000000) | (r << 16) | (g << 8) | (b);
    }
}