/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.settings;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author Vity
 */
class SpinnerOption implements IOptionable<JSpinner>, ChangeListener {
    private final Object initValue;
    private Object applyedValue;
    private Object defaultValue = 10;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private final JSpinner spinner;

    public SpinnerOption(final OptionsGroupManager optionsGroupManager, final SpinnerModel spinnerModel, final IOptionGroup group) {
        spinner = new JSpinner(spinnerModel);
        this.initValue = applyedValue = spinner.getValue();
        this.group = group;
        this.spinner.setValue(initValue);
        this.optionsGroupManager = optionsGroupManager;
//        this.optionsGroupManager.registerOptionable(this);
        this.spinner.addChangeListener(this);
    }

    private void updateValue() {
        wasChanged = !applyedValue.equals(this.spinner.getValue());
        optionsGroupManager.makeChange(this);
    }

    public final void stateChanged(final ChangeEvent e) {
        updateValue();
    }

    public final void setDefaultValue(final Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final void setDefault() {
        this.spinner.setValue(this.defaultValue);
    }

    public final void restorePrevious() {
        this.spinner.setValue(initValue);
    }

    public final boolean wasChanged() {
        return wasChanged;  //implement - call to super class
    }

    public void applyChange() {
        wasChanged = false;
        applyedValue = this.spinner.getValue();
    }

    public JSpinner getComponent() {
        return spinner;
    }

// --Commented out by Inspection START (6.11.06 0:15):
//    public JSpinner getSpinner() {
//        return spinner;
//    }
// --Commented out by Inspection STOP (6.11.06 0:15)

    public final IOptionGroup getOptionsGroup() {
        return group;  //implement - call to super class
    }

}
