/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area;

import net.wordrider.core.swing.ColorPainterFactory;

import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;

/**
 * @author Vity
 */
class RiderCaret extends DefaultCaret {
    private static final Highlighter.HighlightPainter unfocusedPainter = ColorPainterFactory.createColorPainter(ColorStyles.COLOR_TEXT_NOTFOCUSED);
    // private static final Highlighter.HighlightPainter unfocusedPainter = new JaggedUnderlinePainter();

    private boolean isFocused;

    protected final Highlighter.HighlightPainter getSelectionPainter() {
        return isFocused ? super.getSelectionPainter()
                : unfocusedPainter;
    }

    public final void setSelectionVisible(final boolean hasFocus) {
        if (hasFocus != isFocused) {
            isFocused = hasFocus;
            super.setSelectionVisible(false);
            super.setSelectionVisible(true);
        }
    }

}