/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.utilities.LogUtils;

import javax.swing.*;
import javax.swing.text.BadLocationException;
import java.util.logging.Logger;

/**
 * @author Vity
 */
final class LoadFileAction extends RiderSwingWorker {
    private final DocumentProducer documentProducer;
    private final static Logger logger = Logger.getLogger(LoadFileAction.class.getName());

    public LoadFileAction(final DocumentProducer batchTextRead) {
        super(true);    //call to super
        this.documentProducer = batchTextRead;
        //   dialogToClose.setTitle("message.loading");
    }


    public final Object construct() {
        final JProgressBar progress = dialogToClose.getProgressBar();
        progress.setIndeterminate(false);
        progress.setStringPainted(true);
        showInfoWhileLoading("message.loading");
        try {            
            return documentProducer.process(progress);
        } catch (BadLocationException e) {
            errorMessage = e.getMessage();
            LogUtils.processException(logger, e);
            return null;
        }
    }
}
