/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.interfaces.IHidAble;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class ToggleStatusBarAction extends CoreAction {
    private final static ToggleStatusBarAction instance = new ToggleStatusBarAction();
    private final static String CODE = "ToggleStatusBarAction";
    private JMenuItem menuItem;

    public static ToggleStatusBarAction getInstance(final JMenuItem menuItem) {
        instance.menuItem = menuItem;
        menuItem.setSelected(AppPrefs.getProperty(AppPrefs.SHOW_STATUSBAR, true));
        return instance;
    }

    private ToggleStatusBarAction() {
        super(CODE, KeyStroke.getKeyStroke("F12"), null);    //call to super
    }

    public final void actionPerformed(final ActionEvent e) {
        final IHidAble hidAble = getManagerDirector().getStatusbarManager();
        hidAble.setVisible(!hidAble.isVisible());
        menuItem.setSelected(hidAble.isVisible());
    }
}
