/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.files.ti68kformat;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author Vity
 */
public class FastTextFileReader extends FastTIFileReader {
    private final static Pattern pictureRegexp = Pattern.compile("^( |\f)&P\\p{Alpha}\\w{0,7}\\\\\\p{Alpha}\\w{0,7}$", Pattern.MULTILINE);

    protected String[] getSupportedHeaders() {
        return TIFileConstants.SUPPORTED_FORMATS_TEXT;
    }


    public void showPictures() {
        String searchString = "";
        try {
            byteContent[7] = '\r';
            searchString = new String(byteContent, 7, byteContent.length - 9, "ASCII");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        Matcher matcher = pictureRegexp.matcher(searchString);
        while (matcher.find()) {
            System.out.println(matcher.group().trim());
        }
    }

    protected byte getDataType() {
        return TIFileConstants.DATATYPE_TEXT;
    }


    public String getContent() {
        return null;
    }
}
