/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.Lng;
import net.wordrider.core.managers.SupportedLanguage;
import net.wordrider.utilities.Swinger;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class ChangeLanguageAction extends CoreAction {
    private final static String CODE = "ChangeLanguageAction";
    private final String languageCode;


    public ChangeLanguageAction(final SupportedLanguage lang) {
        super(CODE + lang.getLanguageCode(), lang.getName(), lang.getMnemonic(), lang.getIcon());    //call to super
        this.languageCode = lang.getLanguageCode();
    }


    public final void actionPerformed(final ActionEvent e) {
        if (!languageCode.equals(Lng.getSelectedLanguageCode())) {
            Lng.setSelectedLanguageCode(languageCode);
            Lng.reloadLangProperties();
            Swinger.showInformationDialog(getMainFrame(), Lng.getLabel("ChangeLanguageAction.set"));
        } else
            ((JMenuItem) e.getSource()).setSelected(true);
    }
}
