/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.dialogs.CloseDialog;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;

/**
 * @author Vity
 */
public final class CloseAllAction extends CoreAction {
    private static final CloseAllAction instance = new CloseAllAction();

    private CloseAllAction() {
        super("CloseAllAction", KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK), null);
    }


    public static CloseAllAction getInstance() {
        return instance;
    }

    public static boolean closeAll() {
        final AreaManager areaManager = AreaManager.getInstance();
        final Collection<FileInstance> modifiedList = areaManager.getModifiedInstances();
        if (!modifiedList.isEmpty()) {
            final CloseDialog<FileInstance> dialog = new CloseDialog<FileInstance>(getMainFrame(), modifiedList);
            if (dialog.getModalResult() != CloseDialog.RESULT_OK)
                return false;
            final Collection<FileInstance> selectedList = dialog.getReturnList();
            if (selectedList != null) {
                //closes all except the selected on the list
                for (FileInstance o : areaManager.getOpenedInstances()) {
                    if (!selectedList.contains(o)) { //is not modified list
                        areaManager.closeInstanceHard(o);
                    }
                }
                for (FileInstance aSelectedList : selectedList) {
                    areaManager.setActivateFileInstance(aSelectedList);
                    if (!SaveFileAction.save(false))
                        return false;
                    areaManager.closeActiveInstance();
                }
            } else
                return false;//user set doClose
        } else {
            for (FileInstance o : areaManager.getOpenedInstances()) {
                areaManager.closeInstanceHard(o);
                //it.remove();
            }
        }
        return true;
    }

    public final void actionPerformed(final ActionEvent e) {
        closeAll();
    }
}
