/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.actions.StyledAreaAction;
import net.wordrider.utilities.LogUtils;

public final class TrimTrailingSpacesAction
extends StyledAreaAction {
    private static final TrimTrailingSpacesAction instance = new TrimTrailingSpacesAction();
    private static final Logger logger = Logger.getLogger(TrimTrailingSpacesAction.class.getName());

    public static TrimTrailingSpacesAction getInstance() {
        return instance;
    }

    private TrimTrailingSpacesAction() {
        super("TrimTrailingSpacesAction", KeyStroke.getKeyStroke(114, 3), "ico_trim-sp.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea == null) {
            return;
        }
        try {
            this.process(riderArea);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RiderArea riderArea) throws BadLocationException {
        RiderDocument riderDocument = riderArea.getDoc();
        int n = riderArea.getSelectionStart();
        int n2 = riderArea.getSelectionEnd();
        Element element = riderDocument.getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        try {
            riderArea.makeGroupChange(true);
            for (int i = n3; i <= n4; ++i) {
                int n5;
                Element element2 = element.getElement(i);
                int n6 = element2.getStartOffset();
                String string = riderDocument.getText(n6, element2.getEndOffset() - n6);
                if (string.length() <= 0) continue;
                char[] cArray = string.toCharArray();
                int n7 = n5 = cArray.length - 1 + (cArray[cArray.length - 1] == '\n' ? -1 : 0);
                while (n5 >= 0 && Character.isWhitespace(cArray[n5])) {
                    --n5;
                }
                if ((n7 -= n5) <= 0) continue;
                riderDocument.remove(n6 + n5 + 1, n7);
            }
        }
        finally {
            riderArea.makeGroupChange(false);
        }
    }
}

