/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.GetNextTabAction;
import net.wordrider.area.actions.GetPrevTabAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.CloseActiveAction;
import net.wordrider.core.actions.CloseAllAction;
import net.wordrider.core.actions.CloseAllButThisAction;
import net.wordrider.core.actions.CloseAllUnmodifiedAction;
import net.wordrider.core.actions.CreateNewFileAction;
import net.wordrider.core.managers.AreaChangeEvent;
import net.wordrider.core.managers.FileChangeEvent;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.InstanceEvent;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.RecentFilesManager;
import net.wordrider.core.managers.TabManager;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IInformedTab;
import net.wordrider.core.managers.interfaces.InstanceListener;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AreaManager
extends TabManager<FileInstance>
implements InstanceListener {
    private final EventListenerList listenerList = new EventListenerList();
    private final RecentFilesManager recentFilesManager;

    public AreaManager(ManagerDirector managerDirector) {
        this.recentFilesManager = new RecentFilesManager(managerDirector.getMenuManager());
        this.addFileChangeListener(this.recentFilesManager);
        this.tabbedPane.setFocusable(true);
        this.applyTabLayout();
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((SwingUtilities.isMiddleMouseButton(mouseEvent) || SwingUtilities.isLeftMouseButton(mouseEvent)) && mouseEvent.getClickCount() >= 2) {
                    mouseEvent.consume();
                    JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
                    int n = jTabbedPane.getUI().tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
                    if (n == -1) {
                        CreateNewFileAction.getInstance().actionPerformed(null);
                    } else {
                        CloseActiveAction.getInstance().actionPerformed(null);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu("popup");
                    if (AreaManager.this.getOpenedInstanceCount() > 0) {
                        jPopupMenu.add(CloseActiveAction.getInstance());
                        jPopupMenu.add(CloseAllButThisAction.getInstance());
                        jPopupMenu.add(CloseAllAction.getInstance());
                        jPopupMenu.add(CloseAllUnmodifiedAction.getInstance());
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(GetNextTabAction.getInstance());
                        jPopupMenu.add(GetPrevTabAction.getInstance());
                    } else {
                        jPopupMenu.add(CreateNewFileAction.getInstance());
                    }
                    jPopupMenu.show(AreaManager.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public final void activateInstance(IFileInstance iFileInstance) {
        if (iFileInstance.equals(this.getActiveInstance())) {
            return;
        }
        for (FileInstance fileInstance : this.runningInstances()) {
            if (!fileInstance.equals(iFileInstance)) continue;
            this.setActivateFileInstance(fileInstance);
        }
    }

    public final IFileInstance isFileAlreadyOpened(File file) {
        for (FileInstance fileInstance : this.runningInstances()) {
            if (!file.equals(fileInstance.getFile())) continue;
            return fileInstance;
        }
        return null;
    }

    public final void openFileInstance() {
        this.openFileInstance(new FileInstance());
    }

    public final void openFileInstance(FileInstance fileInstance) {
        Integer n = this.registerNewOne(fileInstance);
        fileInstance.setInternalId(n);
        this.fireFileOpened(fileInstance);
        fileInstance.addInstanceListener(this);
    }

    @Override
    protected final void deactivateInstance(Object object) {
        super.deactivateInstance(object);
        this.fireAreaDeactivated();
    }

    @Override
    protected final void activateInstance(Object object) {
        super.activateInstance(object);
        this.fireAreaActivated();
    }

    private void fireAreaActivated() {
        IFileInstance iFileInstance = (IFileInstance)this.getActiveInstance();
        if (iFileInstance == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AreaChangeEvent areaChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IAreaChangeListener.class) continue;
            if (areaChangeEvent == null) {
                areaChangeEvent = new AreaChangeEvent(this, iFileInstance);
            }
            ((IAreaChangeListener)objectArray[i + 1]).areaActivated(areaChangeEvent);
        }
    }

    private void fireFileOpened(IFileInstance iFileInstance) {
        Object[] objectArray = this.listenerList.getListenerList();
        FileChangeEvent fileChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IFileChangeListener.class) continue;
            if (fileChangeEvent == null) {
                fileChangeEvent = new FileChangeEvent(this, iFileInstance);
            }
            ((IFileChangeListener)objectArray[i + 1]).fileWasOpened(fileChangeEvent);
        }
    }

    private void fireAreaDeactivated() {
        IFileInstance iFileInstance = (IFileInstance)this.getActiveInstance();
        assert (iFileInstance != null);
        Object[] objectArray = this.listenerList.getListenerList();
        AreaChangeEvent areaChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IAreaChangeListener.class) continue;
            if (areaChangeEvent == null) {
                areaChangeEvent = new AreaChangeEvent(this, iFileInstance);
            }
            ((IAreaChangeListener)objectArray[i + 1]).areaDeactivated(areaChangeEvent);
        }
    }

    private void setTabTitle(IInformedTab iInformedTab) {
        int n = this.tabbedPane.indexOfComponent(iInformedTab.getComponent());
        this.tabbedPane.setTitleAt(n, iInformedTab.getTabName());
    }

    final void addAreaChangeListener(IAreaChangeListener iAreaChangeListener) {
        this.listenerList.add(IAreaChangeListener.class, iAreaChangeListener);
    }

    public final void addFileChangeListener(IFileChangeListener iFileChangeListener) {
        this.listenerList.add(IFileChangeListener.class, iFileChangeListener);
    }

    public final Collection<FileInstance> getModifiedInstances() {
        ArrayList<FileInstance> arrayList = new ArrayList<FileInstance>();
        for (FileInstance fileInstance : this.runningInstances()) {
            if (!fileInstance.isModified()) continue;
            arrayList.add(fileInstance);
        }
        return arrayList;
    }

    public void updateHighlightCurrentLine() {
        boolean bl = AppPrefs.getProperty("settings.linehighlight", true);
        for (FileInstance fileInstance : this.runningInstances()) {
            ((RiderArea)fileInstance.getRiderArea()).setCurrentLineHighlight(bl);
        }
        this.repaintActive();
    }

    public void repaintActive() {
        final IFileInstance iFileInstance = (IFileInstance)this.getActiveInstance();
        if (iFileInstance != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Component)iFileInstance.getRiderArea()).repaint();
                }
            });
        }
    }

    public void updateBracketMatching() {
        boolean bl = AppPrefs.getProperty("settings.matchBrackets", true);
        for (FileInstance fileInstance : this.runningInstances()) {
            ((RiderArea)fileInstance.getRiderArea()).setBracketMatching(bl);
        }
        this.repaintActive();
    }

    public final void setActivateFileInstance(FileInstance fileInstance) {
        this.tabbedPane.setSelectedComponent(fileInstance.getComponent());
    }

    public final void closeInstanceHard(FileInstance fileInstance) {
        fileInstance.removeInstanceListener(this);
        this.closeHard(this.runningTabs.get(fileInstance.getComponent()));
        this.fireFileClosed(fileInstance);
    }

    private void fireFileClosed(IFileInstance iFileInstance) {
        Object[] objectArray = this.listenerList.getListenerList();
        FileChangeEvent fileChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IFileChangeListener.class) continue;
            if (fileChangeEvent == null) {
                fileChangeEvent = new FileChangeEvent(this, iFileInstance);
            }
            ((IFileChangeListener)objectArray[i + 1]).fileWasClosed(fileChangeEvent);
        }
    }

    public final boolean hasModifiedInstances() {
        for (FileInstance fileInstance : this.runningInstances()) {
            if (!fileInstance.isModified()) continue;
            return true;
        }
        return false;
    }

    public final void closeActiveInstance() {
        IFileInstance iFileInstance = (IFileInstance)this.getActiveInstance();
        if (iFileInstance != null) {
            this.closeSoft(this.activeInstanceID, true);
            this.fireFileClosed(iFileInstance);
        }
    }

    public RecentFilesManager getRecentFilesManager() {
        return this.recentFilesManager;
    }

    public final int getOpenedInstanceCount() {
        return this.runningInstancesIDs.size();
    }

    public boolean hasOpenedInstance() {
        return this.getOpenedInstanceCount() > 0;
    }

    public void grabActiveFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IFileInstance iFileInstance = (IFileInstance)AreaManager.this.getActiveInstance();
                if (iFileInstance != null) {
                    AreaManager.grabActiveFocus(iFileInstance);
                }
            }
        });
    }

    public static void grabActiveFocus(IFileInstance iFileInstance) {
        Swinger.inputFocus(iFileInstance.getRiderArea());
    }

    public void applyTabLayout() {
        this.tabbedPane.setTabLayoutPolicy(AppPrefs.getProperty("settings.scrolllayout", true) ? 1 : 0);
    }

    public static AreaManager getInstance() {
        return MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager();
    }

    @Override
    public void instanceModifiedStatusChanged(InstanceEvent instanceEvent) {
        this.fileAssigned(instanceEvent);
    }

    @Override
    public void fileAssigned(InstanceEvent instanceEvent) {
        this.setTabTitle((IInformedTab)instanceEvent.getSource());
    }
}

