/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.wordrider.core.managers.VerticalTextIcon;
import net.wordrider.core.managers.interfaces.IInformedTab;
import net.wordrider.core.managers.interfaces.IRiderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TabManager<C extends IInformedTab>
implements IRiderManager {
    final JTabbedPane tabbedPane;
    private static int anIDCounter;
    final Map<Component, Object> runningTabs = new Hashtable<Component, Object>(4);
    final Map<Object, C> runningInstancesIDs = new Hashtable<Object, C>(4);
    Object activeInstanceID;

    public TabManager() {
        this(1);
    }

    public TabManager(int n) {
        this.tabbedPane = this.createTabbedPane(n);
        this.tabbedPane.getModel().addChangeListener(new TabListener());
        this.tabbedPane.setOpaque(false);
    }

    public final C getActiveInstance() {
        return (C)(this.activeInstanceID != null ? (IInformedTab)this.runningInstancesIDs.get(this.activeInstanceID) : null);
    }

    @Override
    public final Component getManagerComponent() {
        return this.tabbedPane;
    }

    final Integer registerNewOne(C c) {
        return this.registerNewOne(c, true);
    }

    final Integer registerNewOne(C c, boolean bl) {
        Integer n = TabManager.nextID();
        this.runningInstancesIDs.put(n, c);
        JComponent jComponent = c.getComponent();
        this.runningTabs.put(jComponent, n);
        this.addTab(c, jComponent);
        if (bl) {
            this.tabbedPane.setSelectedComponent(jComponent);
        }
        return n;
    }

    private void addTab(C c, Component component) {
        int n = this.tabbedPane.getTabPlacement();
        switch (n) {
            case 2: 
            case 4: {
                this.tabbedPane.addTab(null, new VerticalTextIcon(c.getTabName(), c.getIcon(), n == 4), component, c.getTip());
                return;
            }
        }
        this.tabbedPane.addTab(c.getTabName(), c.getIcon(), component, c.getTip());
    }

    void deactivateInstance(Object object) {
        ((IInformedTab)this.runningInstancesIDs.get(object)).deactivate();
    }

    public void lookAndFeelChanged() {
        Object object = UIManager.get("TabbedPane.textIconGap");
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        UIManager.put("TabbedPane.textIconGap", 1);
        UIManager.put("TabbedPane.tabInsets", new Insets(insets.left, insets.top, insets.right, insets.bottom));
        this.tabbedPane.updateUI();
        UIManager.put("TabbedPane.textIconGap", object);
        UIManager.put("TabbedPane.tabInsets", insets);
    }

    Collection<C> runningInstances() {
        return this.runningInstancesIDs.values();
    }

    public final Collection<C> getOpenedInstances() {
        return new LinkedList<C>(this.runningInstances());
    }

    void activateInstance(Object object) {
        if (this.activeInstanceID != null && this.runningInstancesIDs.containsKey(this.activeInstanceID)) {
            this.deactivateInstance(this.activeInstanceID);
        }
        this.activeInstanceID = object;
        ((IInformedTab)this.runningInstancesIDs.get(object)).activate();
    }

    final void closeSoft(Object object, boolean bl) {
        if (object == null || !this.runningInstancesIDs.containsKey(object)) {
            return;
        }
        boolean bl2 = false;
        try {
            bl2 = ((IInformedTab)this.runningInstancesIDs.get(object)).closeSoft();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        if (bl2 && bl) {
            this.removeInstance(object);
        }
    }

    final void closeHard(Object object) {
        if (object == null || !this.runningInstancesIDs.containsKey(object)) {
            return;
        }
        this.removeInstance(object);
    }

    private synchronized void removeInstance(Object object) {
        IInformedTab iInformedTab = (IInformedTab)this.runningInstancesIDs.get(object);
        this.runningTabs.remove(iInformedTab.getComponent());
        if (this.runningTabs.isEmpty()) {
            this.deactivateInstance(object);
        }
        this.runningInstancesIDs.remove(object);
        this.tabbedPane.remove(iInformedTab.getComponent());
        this.tabbedPane.validate();
        this.activeInstanceID = null;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null) {
            this.activateInstance(this.runningTabs.get(component));
        }
    }

    private JTabbedPane createTabbedPane(int n) {
        switch (n) {
            case 2: 
            case 4: {
                Object object = UIManager.get("TabbedPane.textIconGap");
                Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
                UIManager.put("TabbedPane.textIconGap", 1);
                UIManager.put("TabbedPane.tabInsets", new Insets(insets.left, insets.top, insets.right, insets.bottom));
                JTabbedPane jTabbedPane = new JTabbedPane(n, 1);
                UIManager.put("TabbedPane.textIconGap", object);
                UIManager.put("TabbedPane.tabInsets", insets);
                return jTabbedPane;
            }
        }
        return new JTabbedPane(n, 1);
    }

    public void closeSoftAllInstances(boolean bl) {
        for (Object e : new LinkedList<Object>(this.runningInstancesIDs.keySet())) {
            this.closeSoft(e, bl);
        }
    }

    private static synchronized Integer nextID() {
        return ++anIDCounter;
    }

    public final void getPrevTab() {
        int n = this.runningTabs.size();
        if (n > 1) {
            int n2 = this.tabbedPane.getSelectedIndex();
            if (n2 - 1 < 0) {
                n2 = n;
            }
            this.tabbedPane.setSelectedIndex(n2 - 1);
        }
    }

    public final void getNextTab() {
        int n = this.runningTabs.size();
        if (n > 1) {
            int n2 = this.tabbedPane.getSelectedIndex();
            if (n2 + 1 == n) {
                n2 = -1;
            }
            this.tabbedPane.setSelectedIndex(n2 + 1);
        }
    }

    private final class TabListener
    implements ChangeListener {
        private TabListener() {
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            Component component = TabManager.this.tabbedPane.getSelectedComponent();
            if (component != null) {
                Object object = TabManager.this.runningTabs.get(component);
                if (object != null && !object.equals(TabManager.this.activeInstanceID)) {
                    TabManager.this.activateInstance(object);
                } else if (TabManager.this.activeInstanceID != null) {
                    TabManager.this.deactivateInstance(TabManager.this.activeInstanceID);
                    TabManager.this.activeInstanceID = null;
                }
            } else {
                TabManager.this.activeInstanceID = null;
            }
        }
    }
}

