/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import net.wordrider.utilities.Swinger;

final class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon thumbnail = null;
    private File file = null;
    private static final Logger logger = Logger.getLogger(ImagePreview.class.getName());

    ImagePreview(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    private void loadImage() {
        Image image;
        this.freeResources();
        if (this.file == null) {
            return;
        }
        try {
            image = Swinger.loadPicture(this.file);
        }
        catch (Exception exception) {
            logger.warning("Couldn't read the image file for preview :" + this.file.getPath());
            return;
        }
        if (image != null) {
            this.thumbnail = new ImageIcon(image.getWidth(this) > 90 ? image.getScaledInstance(90, -1, 2) : image);
        }
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            this.file = (File)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (bl) {
            this.freeResources();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    protected final void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }

    void freeResources() {
        if (this.thumbnail != null) {
            this.thumbnail.getImage().flush();
            this.thumbnail = null;
        }
    }
}

