/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.pictures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.wordrider.core.Lng;
import net.wordrider.dialogs.pictures.FilterDialog;

final class InputPicturePanel
extends JComponent
implements MouseMotionListener,
MouseListener,
ActionListener,
KeyListener {
    private Image img = null;
    private static final int BORDER_X = 4;
    private static final int BORDER_Y = 4;
    private int dx = 4;
    private int dy = 4;
    private int paintImageWidth = 0;
    private int paintImageHeight = 0;
    private static final float[] dash = new float[]{4.0f};
    private static final Stroke[] strokes = new Stroke[]{new BasicStroke(1.0f, 2, 2, 0.0f, dash, 7.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 6.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 5.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 4.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 3.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 2.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 1.0f), new BasicStroke(1.0f, 2, 2, 0.0f, dash, 0.0f)};
    private static final int STROKES_COUNT = strokes.length;
    private int selectionX = -1;
    private int selectionY = -1;
    private int selectionEndX = -1;
    private int selectionEndY = -1;
    private int drawRectX;
    private int drawRectY;
    private int drawRectEndX;
    private int drawRectEndY;
    private int mousePosX = 0;
    private int mousePosY = 0;
    private Rectangle rectangle = new Rectangle();
    private final String formatString1 = Lng.getLabel("dialog.images.cropinfo");
    private final String formatString2 = Lng.getLabel("dialog.images.cropposition");
    private final FilterDialog filterDialog;
    private final Timer selectionTimer;
    private final Timer movingTimer = new Timer(100, this);
    private float zoomFactor = 0.5f;
    private int origImageWidth;
    private int origImageHeight;
    private int activeStroke = 0;
    private JViewport viewport = null;
    private Point movePoint;
    private static final int SENSITIVE_BORDER = 10;
    private boolean isMoving = false;
    private Rectangle outputRectangle = new Rectangle();
    private static final String RANGE_OUT = " - ";
    private static final float[] ZOOM_TABLE = new float[]{1.0f, 2.0f, 5.0f, 6.25f, 8.0f, 12.5f, 16.0f, 25.0f, 33.0f, 50.0f, 66.0f, 75.0f, 100.0f, 200.0f, 300.0f, 400.0f, 500.0f, 600.0f, 700.0f, 800.0f, 1200.0f, 1600.0f};

    public InputPicturePanel(FilterDialog filterDialog) {
        this.filterDialog = filterDialog;
        this.setBorder(null);
        this.selectionTimer = new Timer(150, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputPicturePanel.this.activeStroke = (InputPicturePanel.this.activeStroke + 1) % STROKES_COUNT;
                InputPicturePanel.this.updateContent();
            }
        });
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
    }

    void init() {
        this.getViewport().addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                InputPicturePanel.this.componentResized();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    private void recalculateDxy(int n, int n2) {
        JViewport jViewport = this.getViewport();
        int n3 = jViewport.getWidth();
        int n4 = jViewport.getHeight();
        this.dx = n < n3 ? (n3 - this.paintImageWidth) / 2 : (n - this.paintImageWidth) / 2;
        this.dy = n2 < n4 ? (n4 - this.paintImageHeight) / 2 : (n2 - this.paintImageHeight) / 2;
    }

    private void componentResized() {
        this.recalculateDxy(this.getWidth(), this.getHeight());
        this.revalidate();
        this.updateContent();
    }

    private void updateSelectionInfo() {
        boolean bl = this.selectionEndX < this.selectionX;
        boolean bl2 = this.selectionEndY < this.selectionY;
        int n = this.getOrigin(this.selectionX, bl);
        int n2 = this.getOrigin(this.selectionY, bl2);
        int n3 = this.getOrigin(this.selectionEndX, !bl);
        int n4 = this.getOrigin(this.selectionEndY, !bl2);
        this.rectangle.x = Math.min(n, n3);
        this.rectangle.y = Math.min(n2, n4);
        if (!this.isMoving) {
            this.drawRectX = this.getDrawRectX(Math.max(this.rectangle.x, 0));
            this.drawRectY = this.getDrawRectX(Math.max(this.rectangle.y, 0));
            this.outputRectangle.width = this.rectangle.width = Math.max(1, Math.abs(n3 - n));
            this.outputRectangle.height = this.rectangle.height = Math.max(1, Math.abs(n4 - n2));
        } else {
            this.drawRectX = this.getDrawRectX(this.rectangle.x);
            this.drawRectY = this.getDrawRectX(this.rectangle.y);
        }
        this.outputRectangle.width = this.rectangle.width;
        this.outputRectangle.height = this.rectangle.height;
        this.drawRectEndX = this.getDrawRectX(this.rectangle.x + this.rectangle.width);
        this.drawRectEndY = this.getDrawRectX(this.rectangle.y + this.rectangle.height);
        if (this.drawRectEndY == this.paintImageHeight) {
            --this.drawRectEndY;
        }
        if (this.drawRectEndX == this.paintImageWidth) {
            --this.drawRectEndX;
        }
        this.updateSelectionRectangle();
    }

    private void updateInfoPosition(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n >= 0 && n < this.origImageWidth && n2 >= 0 && n2 < this.origImageHeight;
        if (this.isSelection()) {
            boolean bl3 = this.outputRectangle.width > 0 && this.outputRectangle.height > 0;
            this.updateInfoPosition(Lng.formatLabel(this.formatString1, new Object[]{bl ? String.valueOf(n) : RANGE_OUT, bl ? String.valueOf(n2) : RANGE_OUT, bl3 ? String.valueOf(this.outputRectangle.width) : RANGE_OUT, bl3 ? String.valueOf(this.outputRectangle.height) : RANGE_OUT}));
        } else {
            this.updateInfoPosition(Lng.formatLabel(this.formatString2, new Object[]{bl ? String.valueOf(n) : RANGE_OUT, bl ? String.valueOf(n2) : RANGE_OUT}));
        }
    }

    private void updateDrawRect() {
        if (this.isSelection()) {
            this.selectionX = this.drawRectX = this.getDrawRectX(this.rectangle.x);
            this.selectionY = this.drawRectY = this.getDrawRectX(this.rectangle.y);
            this.selectionEndX = this.drawRectEndX = this.getDrawRectX(this.rectangle.x + this.rectangle.width);
            this.selectionEndY = this.drawRectEndY = this.getDrawRectX(this.rectangle.y + this.rectangle.height);
            if (this.drawRectEndY == this.paintImageHeight) {
                --this.drawRectEndY;
            }
            if (this.drawRectEndX == this.paintImageWidth) {
                --this.drawRectEndX;
            }
        }
    }

    private void updateInfoPosition(String string) {
        this.filterDialog.updateLabelInfoPosition(string);
    }

    public final void setImg(Image image) {
        this.img = image;
        if (image != null) {
            this.origImageWidth = image.getWidth(null);
            this.origImageHeight = image.getHeight(null);
            this.mouseExited(null);
            this.updatePaintImage();
        }
    }

    private boolean isIn(MouseEvent mouseEvent) {
        return this.isIn(mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isIn(int n, int n2) {
        return n >= 0 && n < this.paintImageWidth && n2 >= 0 && n2 < this.paintImageHeight;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isSelection()) {
            return;
        }
        Point point = this.getViewport().getViewPosition();
        if (this.viewport == null) {
            return;
        }
        Point point2 = (Point)point.clone();
        int n = this.viewport.getWidth();
        int n2 = this.viewport.getHeight();
        if (this.movePoint.x >= 10 && this.movePoint.x <= n - 10 && this.movePoint.y >= 10 && this.movePoint.y <= n2 - 10) {
            return;
        }
        int n3 = (this.movePoint.x - n / 2) / 4;
        int n4 = (this.movePoint.y - n2 / 2) / 4;
        point.translate(n3, n4);
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.viewport.getView().getWidth() - n) {
            point.x = this.viewport.getView().getWidth() - n;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.viewport.getView().getHeight() - n2) {
            point.y = this.viewport.getView().getHeight() - n2;
        }
        this.viewport.setViewPosition(point);
        Point point3 = SwingUtilities.convertPoint(this.viewport, this.movePoint.x + (point.x - point2.x), this.movePoint.y + (point.y - point2.y), this);
        this.dispatchEvent(new MouseEvent(this, 506, 0L, 0, point3.x, point3.y, 0, false));
    }

    private JViewport getViewport() {
        Container container;
        if (this.viewport != null) {
            return this.viewport;
        }
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            this.viewport = jScrollPane.getViewport();
            if (this.viewport == null || this.viewport.getView() != this) {
                this.viewport = null;
                return null;
            }
            return this.viewport;
        }
        return null;
    }

    private void updatePaintImage() {
        this.paintImageWidth = Math.round((float)this.origImageWidth * this.zoomFactor);
        this.paintImageHeight = Math.round((float)this.origImageHeight * this.zoomFactor);
        Dimension dimension = new Dimension(this.paintImageWidth + 8, this.paintImageHeight + 8);
        this.recalculateDxy(dimension.width, dimension.height);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.getViewport().revalidate();
    }

    private void updateContent() {
        this.repaint();
    }

    private void updateCropLines(Graphics2D graphics2D) {
        graphics2D.setStroke(strokes[this.activeStroke]);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setXORMode(Color.BLACK);
        graphics2D.drawPolygon(new int[]{this.drawRectX, this.drawRectEndX, this.drawRectEndX}, new int[]{this.drawRectY, this.drawRectY, this.drawRectEndY}, 3);
        graphics2D.drawPolygon(new int[]{this.drawRectX, this.drawRectX, this.drawRectEndX}, new int[]{this.drawRectY, this.drawRectEndY, this.drawRectEndY}, 3);
    }

    public final void paintComponent(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(Color.YELLOW);
        graphics.drawRect(this.dx - 1, this.dy - 1, this.paintImageWidth + 1, this.paintImageHeight + 1);
        graphics2D.translate(this.dx, this.dy);
        graphics2D.scale(this.zoomFactor, this.zoomFactor);
        graphics2D.drawImage(this.img, 0, 0, null);
        graphics2D.scale(1.0f / this.zoomFactor, 1.0f / this.zoomFactor);
        if (this.selectionX != -1) {
            int n;
            int n2;
            int n3;
            int n4;
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle.x + rectangle.width >= this.paintImageWidth) {
                n4 = 0;
                n3 = this.paintImageWidth;
            } else {
                n4 = Math.max(0, rectangle.x);
                n3 = Math.min(this.paintImageWidth - rectangle.x - 1, rectangle.width);
            }
            if (rectangle.y + rectangle.height >= this.paintImageHeight) {
                n2 = 0;
                n = this.paintImageHeight;
            } else {
                n2 = Math.max(0, rectangle.y);
                n = Math.min(this.paintImageHeight - rectangle.y - 1, rectangle.height);
            }
            graphics2D.setClip(n4, n2, n3, n);
            this.updateCropLines(graphics2D);
        }
    }

    public final boolean isSelection() {
        return this.selectionX != -1;
    }

    public final Rectangle getSelectionRectangle() {
        return this.outputRectangle;
    }

    private void updateSelectionRectangle() {
        if (!this.isSelection()) {
            this.outputRectangle.setBounds(0, 0, this.origImageWidth, this.origImageHeight);
        } else {
            this.outputRectangle.x = this.rectangle.x;
            this.outputRectangle.y = this.rectangle.y;
            if (this.outputRectangle.x >= this.origImageWidth || this.outputRectangle.y >= this.origImageHeight) {
                this.outputRectangle.width = 0;
                this.outputRectangle.height = 0;
            } else {
                if (this.outputRectangle.x < 0) {
                    this.outputRectangle.x = 0;
                    this.outputRectangle.width = Math.min(Math.max(this.rectangle.width + this.rectangle.x, 0), this.outputRectangle.width);
                } else {
                    this.outputRectangle.width = Math.min(Math.abs(this.origImageWidth - this.rectangle.x), this.outputRectangle.width);
                }
                if (this.outputRectangle.y < 0) {
                    this.outputRectangle.y = 0;
                    this.outputRectangle.height = Math.min(Math.max(this.rectangle.height + this.rectangle.y, 0), this.outputRectangle.height);
                } else {
                    this.outputRectangle.height = Math.min(Math.abs(this.origImageHeight - this.rectangle.y), this.outputRectangle.height);
                }
            }
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        if (this.img == null) {
            return;
        }
        mouseEvent.translatePoint(-this.dx, -this.dy);
        boolean bl = this.isIn(mouseEvent);
        if (this.isSelection() && bl && this.isInDrawSelection(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.getCursor().getType() != 13) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.getCursor().getType() != 1) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
        this.updateInfoPosition(mouseEvent);
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        if (this.img == null) {
            return;
        }
        this.movePoint = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), this.viewport);
        mouseEvent.translatePoint(-this.dx, -this.dy);
        if (this.isMoving) {
            int n = mouseEvent.getX() - this.mousePosX;
            int n2 = mouseEvent.getY() - this.mousePosY;
            this.selectionX += n;
            this.selectionY += n2;
            this.selectionEndX += n;
            this.selectionEndY += n2;
            this.mousePosX = mouseEvent.getX();
            this.mousePosY = mouseEvent.getY();
        } else {
            if (this.isIn(mouseEvent)) {
                this.selectionEndX = mouseEvent.getX();
                this.selectionEndY = mouseEvent.getY();
                if (this.selectionX == -1) {
                    this.selectionX = Math.min(this.paintImageWidth - 1, Math.max(this.mousePosX, 0));
                    this.selectionY = Math.min(this.paintImageHeight - 1, Math.max(this.mousePosY, 0));
                }
            } else {
                this.selectionEndX = Math.min(this.paintImageWidth - 1, Math.max(mouseEvent.getX(), 0));
                this.selectionEndY = Math.min(this.paintImageHeight - 1, Math.max(mouseEvent.getY(), 0));
            }
            this.mousePosX = mouseEvent.getX();
            this.mousePosY = mouseEvent.getY();
        }
        this.updateSelectionInfo();
        this.updateInfoPosition(mouseEvent);
        this.updateContent();
    }

    private void updateInfoPosition(MouseEvent mouseEvent) {
        int n = this.getOrigin(mouseEvent.getX(), false);
        int n2 = this.getOrigin(mouseEvent.getY(), false);
        this.updateInfoPosition(n, n2);
    }

    private boolean isInDrawSelection(int n, int n2) {
        return n >= this.drawRectX && n2 >= this.drawRectY && n <= this.drawRectEndX && n2 <= this.drawRectEndY;
    }

    private int getDrawRectX(int n) {
        return (int)((float)n * this.zoomFactor);
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.img == null) {
            return;
        }
        mouseEvent.translatePoint(-this.dx, -this.dy);
        this.isMoving = this.isIn(mouseEvent) && this.isSelection() && this.isInDrawSelection(mouseEvent.getX(), mouseEvent.getY());
        this.mousePosX = Math.min(this.paintImageWidth, Math.max(mouseEvent.getX(), 0));
        this.mousePosY = Math.min(this.paintImageHeight, Math.max(mouseEvent.getY(), 0));
        if (!this.isMoving) {
            this.selectionEndX = -1;
            this.selectionX = -1;
            this.selectionEndY = -1;
            this.selectionY = -1;
            this.updateContent();
            this.selectionTimer.start();
        } else {
            this.outputRectangle.width = this.rectangle.width;
            this.outputRectangle.height = this.rectangle.height;
            this.selectionTimer.stop();
        }
        this.movingTimer.start();
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (this.img == null) {
            return;
        }
        this.movingTimer.stop();
        this.selectionTimer.stop();
        this.isMoving = false;
        this.updateSelectionRectangle();
        if (this.isSelection()) {
            if (!(this.outputRectangle.getWidth() > 0.0) || !(this.outputRectangle.getHeight() > 0.0)) {
                this.selectionTimer.stop();
                this.selectionEndY = -1;
                this.selectionY = -1;
                this.selectionEndX = -1;
                this.selectionX = -1;
                this.updateInfoPosition(mouseEvent);
                this.updateContent();
            } else {
                this.selectionTimer.start();
            }
        }
        if (this.filterDialog.isCropEnabled()) {
            this.filterDialog.updateFilter(1, 3);
        }
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        this.updateInfoPosition(-1, -1);
    }

    private int getOrigin(int n, boolean bl) {
        n = (int)((float)n / this.zoomFactor);
        if (bl) {
            ++n;
        }
        return n;
    }

    private void updateZoom(float f) {
        Point point = new Point();
        JViewport jViewport = this.getViewport();
        Point point2 = jViewport.getViewPosition();
        int n = jViewport.getWidth();
        int n2 = jViewport.getHeight();
        point.x = (int)((float)point2.x + (f / this.zoomFactor * (float)this.getWidth() - (float)this.getWidth()) / 2.0f);
        point.y = (int)((float)point2.y + (f / this.zoomFactor * (float)this.getHeight() - (float)this.getHeight()) / 2.0f);
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= jViewport.getView().getWidth() - n) {
            point.x = jViewport.getView().getWidth() - n;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= jViewport.getView().getHeight() - n2) {
            point.y = jViewport.getView().getHeight() - n2;
        }
        this.zoomFactor = f;
        this.updatePaintImage();
        this.updateDrawRect();
        this.filterDialog.getScrollPaneInput().validate();
        jViewport.setViewPosition(point);
        this.updateContent();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '+') {
            this.updateZoom(this.getNextZoom(this.zoomFactor, true));
        } else if (keyEvent.getKeyChar() == '-') {
            this.updateZoom(this.getNextZoom(this.zoomFactor, false));
        }
    }

    public void freeResources() {
        this.selectionTimer.stop();
        this.selectionTimer.removeActionListener(this);
        this.movingTimer.stop();
    }

    private float getNextZoom(float f, boolean bl) {
        int n;
        f *= 100.0f;
        int n2 = ZOOM_TABLE.length;
        if (bl) {
            for (n = 0; n < n2 && Float.compare(f, ZOOM_TABLE[n]) >= 0; ++n) {
            }
            if (n == n2) {
                n = n2 - 1;
            }
        } else {
            for (n = n2 - 1; n >= 0 && Float.compare(f, ZOOM_TABLE[n]) <= 0; --n) {
            }
            if (n < 0) {
                n = 0;
            }
        }
        return ZOOM_TABLE[n] / 100.0f;
    }
}

