/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

public final class AppPrefs {
    private static final Logger logger = Logger.getLogger(AppPrefs.class.getName());
    private static final String DEFAULT_PROPERTIES = "wordrider.properties";
    private static final String USER_PROPERTIES_WINDOWS = "Application Data\\WordRider\\wordrider.properties";
    private static final String USER_PROPERTIES_MACOS = "Library/Preferences/wordrider.properties";
    private static final String USER_PROPERTIES_LINUX = ".wordrider.properties";
    private static final String CLASS_EXT = ".class";
    private static final String JAR_SEPARATOR = "!/";
    private static final String URL_SEPARATOR = "/";
    private static final String CLASS_SEPARATOR = ".";
    private static final String FILE_PREFIX = "file:";
    private static volatile String appPath = null;
    private static volatile String propertiesFile = null;
    private static volatile Properties properties = AppPrefs.loadDefaultProperties();
    public static final String PROXY_USE = "settings.proxy.proxy";
    public static final String PROXY_URL = "settings.proxy.url";
    public static final String PROXY_SAVEPASSWORD = "settings.proxy.savepassword";
    public static final String PROXY_PORT = "settings.proxy.port";
    public static final String PROXY_LOGIN = "settings.proxy.login";
    public static final String PROXY_USERNAME = "settings.proxy.username";
    public static final String PROXY_PASSWORD = "settings.proxy.password";
    public static final String TABSIZE = "settings.tabsize";
    public static final String ANTIALIASING = "settings.antialiasing";
    public static final String ONEINSTANCE = "settings.oneinstance";
    public static final String WINDOWSPOSITION = "settings.position";
    public static final String WINDOWSPOSITION_WIDTH = "settings.positionW";
    public static final String WINDOWSPOSITION_HEIGHT = "settings.positionH";
    public static final String WINDOWSPOSITION_MAXIMIZED = "settings.positionMax";
    public static final String WINDOWSPOSITION_X = "settings.positionX";
    public static final String WINDOWSPOSITION_Y = "settings.positionY";
    public static final String NEW_FILE_AFTER_START = "settings.newfile";
    public static final String INFO_SUCCESFUL = "settings.infosave";
    public static final String MAX_RECENT_FILES = "settings.recentcount";
    public static final String USED_CHARS_SAVE = "settings.usedcharsSave";
    public static final String USED_CHARS = "settings.usedchars";
    public static final String USE_EMULATION_CODE = "settings.emulation";
    public static final String NEW_VERSION = "settings.newversion";
    public static final String ALT_KEY_FOR_MENU = "settings.altmenu";
    public static final String DRAG_AND_DROP = "settings.dragndrop";
    public static final String TI92IMAGEFORMAT = "settings.ti92ImageFormat";
    public static final String SHOW_IMAGEFORMAT = "settings.imageFormatRemember";
    public static final String REMEMBER_INSERT_IMAGE = "settings.insertImage";
    public static final String RENAME_IMAGE_AUTOMATICALLY = "settings.renameImageDialog";
    public static final String LAST_USED_OUTPUTFORMAT = "settings.outputFormat";
    public static final String LAST_USED_OPENFILTER = "settings.openfilter";
    public static final String LAST_USED_SAVEFILTER = "settings.savefilter";
    public static final String TIINPUTTEXTFORMAT = "settings.inputFormatHibview";
    public static final String SHOWINPUTFORMAT = "settings.inputFormatRemember";
    public static final String DECORATED_FRAMES = "settings.decorated";
    public static final String SCROLL_LAYOUT = "settings.scrolllayout";
    public static final String MATCH_BRACKET_MATHONLY = "settings.matchbracketmath";
    public static final String HIGHLIGHT_LINE = "settings.linehighlight";
    public static final String MATCH_BRACKETS = "settings.matchBrackets";
    public static final String DEFAULT_FOLDER = "settings.defaultFolder";
    public static final String DEFAULT_VARIABLE = "settings.defaultVariable";
    public static final String DEFAULT_COMMENT = "settings.defaultComment";
    public static final String HIBVIEW_BUTTONS = "settings.hibviewButtons";
    public static final String CALC_SEND_METHOD = "settings.sendMethod";
    public static final String TICONNECT_PATH = "settings.ticonnectPath";
    public static final String TILP_PATH = "settings.tilpPath";
    public static final String TILP_PARAMETERS = "settings.tilpParameters";
    public static final String LIST_SORT = "settings.listSort";
    public static final String SEND_WITH_PICTURES = "settings.sendWithPictures";
    public static final String LASTOPENFOLDER_KEY = "settings.lastOpenFolder";
    public static final String NOTEFOLIO_SEPARATOR = "settings.notefolioSeparator";
    public static final String NOTEFOLIO_BREAKPOINT = "settings.notefolioBreakpoint";
    public static final String FRAME_TITLE = "settings.frameTitle";
    public static final String FRAME_TITLE_TYPE = "settings.frameTitleType";
    public static final String SHOW_STATUSBAR = "settings.showStatusbar";

    private AppPrefs() {
    }

    private static synchronized Properties loadDefaultProperties() {
        String string = System.getProperty("os.name");
        String string2 = string == null || string.startsWith("Windows") ? USER_PROPERTIES_WINDOWS : (string.startsWith("Linux") ? USER_PROPERTIES_LINUX : (string.startsWith("Mac") ? USER_PROPERTIES_MACOS : USER_PROPERTIES_WINDOWS));
        propertiesFile = System.getProperty("user.home") + File.separator + string2;
        File file = new File(propertiesFile);
        String string3 = !file.exists() ? new StringBuilder(35).append(AppPrefs.getAppPath()).append(File.separator).append(DEFAULT_PROPERTIES).toString() : propertiesFile;
        properties = Utils.loadProperties(string3, false);
        return properties;
    }

    public static int getProperty(String string, int n) {
        try {
            return Integer.parseInt(properties.getProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static boolean getProperty(String string, boolean bl) {
        String string2 = properties.getProperty(string, String.valueOf(bl));
        return Boolean.valueOf(string2);
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static void removeProperty(String string) {
        properties.remove(string);
    }

    public static void store() {
        if (!AppPrefs.getProperty(PROXY_SAVEPASSWORD, false)) {
            properties.remove(PROXY_PASSWORD);
        }
        OutputStream outputStream = null;
        try {
            File file;
            File file2 = new File(propertiesFile);
            if (!file2.exists() && (file = file2.getParentFile()) != null) {
                file.mkdirs();
            }
            outputStream = new FileOutputStream(file2);
            properties.store(outputStream, "WordRider 0.8" + System.getProperty("line.separator", "\n") + "#WordRider properties. Only for experienced users.");
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException2) {
                LogUtils.processException(logger, iOException2);
            }
            logger.severe("Couldn't save app properties. This is a fatal error. Please reinstall the application.");
            LogUtils.processException(logger, iOException);
        }
        logger.info("Properties were saved successfuly");
    }

    public static String getAppPath() {
        if (appPath != null) {
            return appPath;
        }
        String string = Utils.class.getName();
        int n = string.length() + CLASS_EXT.length();
        int n2 = string.lastIndexOf(CLASS_SEPARATOR);
        boolean bl = logger.isLoggable(Level.INFO);
        if (n2 > -1) {
            string = string.substring(n2 + 1);
        }
        if (bl) {
            logger.info("ClassName " + string + CLASS_EXT);
        }
        URL uRL = Utils.class.getResource(string + CLASS_EXT);
        if (bl) {
            logger.info("URL " + uRL);
        }
        if (uRL != null) {
            int n3;
            String string2 = uRL.toString();
            if (bl) {
                logger.info("Url string1 " + string2);
            }
            if ((n2 = string2.lastIndexOf(JAR_SEPARATOR)) > -1) {
                string2 = string2.substring(0, n2);
                if (bl) {
                    logger.info("URL String2 " + string2);
                }
                n3 = string2.lastIndexOf(URL_SEPARATOR) + 1;
            } else {
                n3 = string2.length() - n;
            }
            n2 = string2.lastIndexOf(FILE_PREFIX);
            n2 = n2 > -1 ? (n2 += FILE_PREFIX.length() + (Utils.isWindows() ? 1 : 0)) : 0;
            string2 = string2.substring(n2, n3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("App Path is " + string2);
            }
            String string3 = "";
            try {
                string3 = URLDecoder.decode(string2, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogUtils.processException(logger, unsupportedEncodingException);
            }
            appPath = string3;
            return appPath;
        }
        return "";
    }

    public static void storeProperty(String string, boolean bl) {
        properties.setProperty(string, String.valueOf(bl));
    }

    public static void storeProperty(String string, String string2, boolean bl) {
        properties.setProperty(string, string2);
        if (bl) {
            AppPrefs.store();
        }
    }

    public static void storeProperty(String string, String string2) {
        properties.setProperty(string, string2);
    }

    public static void storeProperty(String string, int n) {
        properties.setProperty(string, String.valueOf(n));
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }
}

