/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JProgressBar;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.wordrider.area.AreaImage;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.actions.BatchRead;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.files.InvalidDataTypeException;
import net.wordrider.files.NotSupportedFileException;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIImageDecoder;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

final class BatchTextRead
extends BatchRead {
    private boolean setBookmark;
    private Collection<Integer> bookmarkList;
    private int linesCount;
    private final boolean isHibviewFormat;
    private final boolean isTi92format;
    private final String dir;

    public BatchTextRead(IFileInstance iFileInstance, String string) {
        super(iFileInstance, string);
        File file = iFileInstance.getFile();
        this.isTi92format = !Utils.getExtension(file).equals("89t");
        this.dir = file.getParent();
        this.isHibviewFormat = iFileInstance.getFileInfo().isHibviewFormat();
    }

    private void init() {
        this.setBookmark = false;
        this.linesCount = 0;
        this.bookmarkList = new LinkedList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document process(JProgressBar jProgressBar) throws BadLocationException {
        this.init();
        int n = this.content.length();
        char[] cArray = this.content.toCharArray();
        BatchTextRead.initProgressBar(jProgressBar, n);
        int n2 = n / 100 * 4;
        if (n2 <= 0) {
            n2 = 1;
        }
        int n3 = 1;
        StringBuilder stringBuilder = new StringBuilder(3);
        block75: for (int i = 0; i < n; ++i) {
            if (i % n2 == 0) {
                jProgressBar.setValue(i);
            }
            char c = cArray[i];
            switch (n3) {
                case 5: {
                    switch (c) {
                        case '\r': {
                            n3 = 1;
                            continue block75;
                        }
                        case '#': {
                            n3 = 4;
                            continue block75;
                        }
                    }
                    this.appendChar(c);
                    continue block75;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            this.setBookmark = false;
                            n3 = 2;
                            continue block75;
                        }
                        case '\f': {
                            this.setBookmark = true;
                            n3 = 2;
                            continue block75;
                        }
                        case '\r': {
                            this.setBookmark = false;
                            continue block75;
                        }
                    }
                    this.setBookmark = true;
                    n3 = 2;
                    continue block75;
                }
                case 2: {
                    switch (c) {
                        case '#': {
                            this.insertNewLine();
                            n3 = 4;
                            continue block75;
                        }
                        case '&': {
                            n3 = 3;
                            continue block75;
                        }
                        case '\r': {
                            this.insertNewLine();
                            n3 = 1;
                            continue block75;
                        }
                    }
                    this.insertNewLine();
                    this.appendChar(c);
                    n3 = 5;
                    continue block75;
                }
                case 4: {
                    MutableAttributeSet mutableAttributeSet = null;
                    switch (c) {
                        case '\r': {
                            this.textBuffer.append('#');
                            n3 = 1;
                            break;
                        }
                        case '1': {
                            mutableAttributeSet = RiderStyles.miniStyle;
                            n3 = 5;
                            break;
                        }
                        case '2': {
                            mutableAttributeSet = RiderStyles.normalStyle;
                            n3 = 5;
                            break;
                        }
                        case '3': {
                            mutableAttributeSet = RiderStyles.maxiStyle;
                            n3 = 5;
                            break;
                        }
                        case 'U': {
                            mutableAttributeSet = RiderStyles.updateUnderlineAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'E': {
                            mutableAttributeSet = RiderStyles.updateExposantAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'D': {
                            if (this.isHibviewFormat) {
                                mutableAttributeSet = RiderStyles.updateSubscriptAttributes(this.attr);
                                n3 = 5;
                                break;
                            }
                        }
                        case 'N': {
                            mutableAttributeSet = RiderStyles.updateUnderlineDottedAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'V': {
                            mutableAttributeSet = RiderStyles.updateVectorAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'J': {
                            if (this.isHibviewFormat) {
                                mutableAttributeSet = RiderStyles.updateConjugateAttributes(this.attr);
                                n3 = 5;
                                break;
                            }
                        }
                        case 'I': {
                            mutableAttributeSet = RiderStyles.updateInvertAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'S': {
                            mutableAttributeSet = RiderStyles.updateStrikedAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case 'W': {
                            mutableAttributeSet = RiderStyles.updateWordWrapAttributes(this.attr);
                            n3 = 5;
                            break;
                        }
                        case '#': {
                            if (this.isHibviewFormat) {
                                this.textBuffer.append('#');
                                n3 = 5;
                                break;
                            }
                        }
                        default: {
                            this.textBuffer.append('#');
                            this.appendChar(c);
                            n3 = 5;
                        }
                    }
                    if (mutableAttributeSet == null) continue block75;
                    this.insertContent();
                    this.attr.addAttributes(mutableAttributeSet);
                    continue block75;
                }
                case 6: {
                    switch (c) {
                        case '\r': {
                            n3 = 1;
                            continue block75;
                        }
                    }
                    this.appendChar(c);
                    continue block75;
                }
                case 7: {
                    switch (c) {
                        case '\r': {
                            this.appendPicture(this.dir);
                            n3 = 1;
                            continue block75;
                        }
                    }
                    this.textBuffer.append(c);
                    continue block75;
                }
                case 3: {
                    switch (c) {
                        case 'E': {
                            this.insertNewLineWithAttr(RiderStyles.mathStyle);
                            n3 = 6;
                            continue block75;
                        }
                        case 'P': {
                            this.insertNewLine();
                            n3 = 7;
                            continue block75;
                        }
                        case '\r': {
                            this.insertNewLine();
                            this.textBuffer.append('&');
                            n3 = 1;
                            continue block75;
                        }
                        case '=': {
                            this.appendSeparateLine(1);
                            n3 = 0;
                            continue block75;
                        }
                        case '-': {
                            this.appendSeparateLine(0);
                            n3 = 0;
                            continue block75;
                        }
                        case 'L': 
                        case '\\': {
                            n3 = 5;
                            this.paraA = RiderStyles.alignmentLeftStyle;
                            this.insertNewLine();
                            continue block75;
                        }
                        case 'R': {
                            n3 = 5;
                            this.paraA = RiderStyles.alignmentRightStyle;
                            this.insertNewLine();
                            continue block75;
                        }
                        case 'C': {
                            n3 = 5;
                            this.paraA = RiderStyles.alignmentCenteredStyle;
                            this.insertNewLine();
                            continue block75;
                        }
                        case ',': {
                            n3 = 5;
                            this.paraA = RiderStyles.margin10Style;
                            this.insertNewLine();
                            continue block75;
                        }
                        case ';': {
                            n3 = 5;
                            this.paraA = RiderStyles.margin20Style;
                            this.insertNewLine();
                            continue block75;
                        }
                        case '.': {
                            n3 = 5;
                            this.paraA = RiderStyles.margin30Style;
                            this.insertNewLine();
                            continue block75;
                        }
                        case 'M': {
                            if (this.isHibviewFormat) {
                                n3 = 8;
                                continue block75;
                            }
                        }
                        case '&': {
                            if (!this.isHibviewFormat) break;
                            this.insertNewLine();
                            this.textBuffer.append('&');
                            n3 = 5;
                            continue block75;
                        }
                    }
                    this.insertNewLine();
                    this.textBuffer.append('&');
                    this.appendChar(c);
                    n3 = 5;
                    continue block75;
                }
                case 0: {
                    if (c != '\r') continue block75;
                    n3 = 1;
                    continue block75;
                }
                case 8: {
                    stringBuilder.append(c);
                    if (stringBuilder.length() != 3) continue block75;
                    boolean bl = true;
                    try {
                        this.paraA = RiderStyles.getMarginXStyle(Integer.parseInt(stringBuilder.toString()));
                        continue block75;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        continue block75;
                    }
                    finally {
                        stringBuilder = new StringBuilder(3);
                        this.insertNewLine();
                        if (!bl) {
                            this.textBuffer.append("&M").append((CharSequence)stringBuilder);
                        }
                        n3 = 5;
                    }
                }
            }
        }
        switch (n3) {
            case 5: 
            case 6: {
                this.insertContent();
                break;
            }
            case 3: {
                this.insertNewLine();
                this.textBuffer.append('&');
                this.insertContent();
                break;
            }
            case 4: {
                this.insertNewLine();
                this.textBuffer.append('#');
                this.insertContent();
                break;
            }
            case 7: {
                this.appendPicture(this.dir);
                break;
            }
            case 2: {
                this.insertNewLine();
                break;
            }
            case 8: {
                this.insertNewLine();
                this.textBuffer.append("&M").append((CharSequence)stringBuilder);
                this.insertContent();
            }
        }
        this.insertNewLine();
        this.doc.processBatchUpdates(0, true);
        if (!this.bookmarkList.isEmpty()) {
            Element element = this.doc.getDefaultRootElement();
            for (int n4 : this.bookmarkList) {
                Element element2 = element.getElement(n4 - 1);
                if (element2 == null || element2.getAttributes().getAttribute("BOOKMARK") == null) continue;
                this.doc.setParagraphAttributes(element2.getStartOffset(), 0, RiderStyles.updateBookmark(element2), false);
            }
        }
        jProgressBar.setValue(n);
        return this.doc;
    }

    protected void insertNewLine() {
        if (this.setBookmark) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.paraA);
            simpleAttributeSet.addAttribute("BOOKMARK", "");
            this.insertNewLineWithAttr(simpleAttributeSet);
            this.bookmarkList.add(this.linesCount);
        } else {
            this.insertNewLineWithAttr(this.paraA);
        }
    }

    void insertNewLineWithAttr(AttributeSet attributeSet) {
        super.insertNewLineWithAttr(attributeSet);
        ++this.linesCount;
    }

    private static boolean checkFile(File file) {
        boolean bl;
        boolean bl2 = bl = file.exists() && file.isFile();
        if (!bl) {
            logger.info("Automatic attempt for loading image file failed " + file.getAbsolutePath());
        }
        return bl;
    }

    private static File getPictureFile(String string, String string2, String string3, String string4, String string5) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        boolean bl = string2.endsWith(string5);
        File file = new File(string + string3 + File.separator + (!bl ? string4 + string5 : string4));
        if (BatchTextRead.checkFile(file)) {
            return file;
        }
        file = new File(string + string3 + File.separator + string4);
        if (BatchTextRead.checkFile(file)) {
            return file;
        }
        file = new File(string + (!bl ? string4 + string5 : string4));
        if (BatchTextRead.checkFile(file)) {
            return file;
        }
        file = new File(string + string4);
        if (BatchTextRead.checkFile(file)) {
            return file;
        }
        file = new File(string + string2);
        if (BatchTextRead.checkFile(file)) {
            return file;
        }
        return null;
    }

    private static Image loadPicture(File file) {
        TIImageDecoder tIImageDecoder = new TIImageDecoder();
        try {
            if (!tIImageDecoder.openFromFile(file)) {
                logger.warning("Image was loaded but the file might be corrupted (invalid checksum)");
            }
            return Toolkit.getDefaultToolkit().createImage(tIImageDecoder);
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            logger.warning(invalidDataTypeException.getMessage());
            return null;
        }
        catch (NotSupportedFileException notSupportedFileException) {
            logger.warning(notSupportedFileException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            logger.warning("Cannot load image " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            logger.severe("Fatal error exception " + exception.getMessage());
            return null;
        }
    }

    private void appendPicture(String string) {
        if (this.textBuffer.length() > 0) {
            Object object;
            Serializable serializable;
            String string2 = this.textBuffer.toString();
            String[] stringArray = string2.split("\\\\", 2);
            Image image = null;
            if (stringArray.length >= 2) {
                serializable = BatchTextRead.getPictureFile(string, string2, stringArray[0], stringArray[1], this.isTi92format ? ".92i" : ".89i");
                if (serializable == null) {
                    serializable = BatchTextRead.getPictureFile(string, string2, stringArray[0], stringArray[1], this.isTi92format ? ".89i" : ".92i");
                }
                if (serializable != null) {
                    image = BatchTextRead.loadPicture((File)serializable);
                }
            }
            if (image == null) {
                object = stringArray.length >= 2 ? new TIFileInfo(stringArray[0], stringArray[1]) : new TIFileInfo("", string2);
                serializable = new AreaImage(Swinger.getIconImage("notfound.gif"), (TIFileInfo)object);
            } else {
                serializable = new AreaImage(image);
            }
            object = new SimpleAttributeSet();
            StyleConstants.setIcon((MutableAttributeSet)object, serializable);
            this.doc.appendBatchString(" ", (AttributeSet)object);
            this.initNewBuffer();
        }
    }
}

