/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.KeyStroke;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.dialogs.CloseDialog;

public final class CloseAllAction
extends CoreAction {
    private static final CloseAllAction instance = new CloseAllAction();

    private CloseAllAction() {
        super("CloseAllAction", KeyStroke.getKeyStroke(67, 3), null);
    }

    public static CloseAllAction getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean closeAll() {
        AreaManager areaManager = AreaManager.getInstance();
        Collection<FileInstance> collection = areaManager.getModifiedInstances();
        if (!collection.isEmpty()) {
            CloseDialog<FileInstance> closeDialog = new CloseDialog<FileInstance>((Frame)CloseAllAction.getMainFrame(), collection);
            if (closeDialog.getModalResult() != 0) {
                return false;
            }
            Collection<FileInstance> collection2 = closeDialog.getReturnList();
            if (collection2 == null) return false;
            for (FileInstance fileInstance : areaManager.getOpenedInstances()) {
                if (collection2.contains(fileInstance)) continue;
                areaManager.closeInstanceHard(fileInstance);
            }
            for (FileInstance fileInstance : collection2) {
                areaManager.setActivateFileInstance(fileInstance);
                if (!SaveFileAction.save(false)) {
                    return false;
                }
                areaManager.closeActiveInstance();
            }
            return true;
        } else {
            for (FileInstance fileInstance : areaManager.getOpenedInstances()) {
                areaManager.closeInstanceHard(fileInstance);
            }
        }
        return true;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        CloseAllAction.closeAll();
    }
}

