/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckBoxOption
implements IOptionable<JCheckBox>,
ItemListener {
    private final boolean initValue;
    private boolean applyedValue;
    private final boolean defaultValue = false;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private String propertyName = null;
    private final JCheckBox check;

    public CheckBoxOption(OptionsGroupManager optionsGroupManager, String string, String string2, boolean bl, IOptionGroup iOptionGroup) {
        this(optionsGroupManager, string, AppPrefs.getProperty(string2, bl), iOptionGroup);
        this.propertyName = string2;
    }

    public CheckBoxOption(OptionsGroupManager optionsGroupManager, String string, boolean bl, IOptionGroup iOptionGroup) {
        this.check = Swinger.getCheckBox(string);
        this.initValue = this.applyedValue = bl;
        this.group = iOptionGroup;
        this.check.setSelected(bl);
        this.optionsGroupManager = optionsGroupManager;
        this.check.addItemListener(this);
    }

    private void updateValue() {
        this.wasChanged = this.applyedValue != this.check.isSelected();
        this.optionsGroupManager.makeChange(this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateValue();
    }

    @Override
    public final void setDefault() {
        this.check.setSelected(this.defaultValue);
    }

    @Override
    public final void restorePrevious() {
        this.check.setSelected(this.initValue);
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.check.isSelected();
        if (this.propertyName != null) {
            AppPrefs.storeProperty(this.propertyName, this.applyedValue);
        }
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JCheckBox getComponent() {
        return this.check;
    }
}

