/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.event.ActionEvent;
import java.util.BitSet;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.NextPrevWordAction;
import net.wordrider.area.views.RiderViewFactory;
import net.wordrider.core.AppPrefs;
import net.wordrider.utilities.LogUtils;

public final class RiderEditorKit
extends StyledEditorKit {
    public static final int DIRECTION_NEXT = 0;
    public static final int DIRECTION_PREVIOUS = 1;
    private static final Logger logger = Logger.getLogger(RiderEditorKit.class.getName());
    private static final Action[] defaultActions = new Action[]{new DefaultEditorKit.DefaultKeyTypedAction(), new InsertTabAction(), new NextPrevWordAction("caret-next-word", false, 0), new NextPrevWordAction("selection-next-word", true, 0), new NextPrevWordAction("caret-previous-word", false, 1), new NextPrevWordAction("selection-previous-word", true, 1)};
    public static final BitSet WORD_SEPARATORS = new BitSet(256);

    public final ViewFactory getViewFactory() {
        return new RiderViewFactory();
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public final Document createDefaultDocument() {
        return new RiderDocument();
    }

    private static String getTab(String string) {
        int n = AppPrefs.getProperty("settings.tabsize", 4);
        if (string.length() != n) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = 32;
            }
            string = new String(cArray);
        }
        return string;
    }

    static {
        WORD_SEPARATORS.set(32);
        WORD_SEPARATORS.set(10);
        WORD_SEPARATORS.set(13);
        WORD_SEPARATORS.set(12);
        WORD_SEPARATORS.set(46);
        WORD_SEPARATORS.set(44);
        WORD_SEPARATORS.set(58);
        WORD_SEPARATORS.set(40);
        WORD_SEPARATORS.set(41);
        WORD_SEPARATORS.set(91);
        WORD_SEPARATORS.set(93);
        WORD_SEPARATORS.set(123);
        WORD_SEPARATORS.set(125);
        WORD_SEPARATORS.set(60);
        WORD_SEPARATORS.set(62);
        WORD_SEPARATORS.set(92);
        WORD_SEPARATORS.set(64);
        WORD_SEPARATORS.set(63);
        WORD_SEPARATORS.set(33);
        WORD_SEPARATORS.set(59);
        WORD_SEPARATORS.set(42);
        WORD_SEPARATORS.set(43);
        WORD_SEPARATORS.set(45);
        WORD_SEPARATORS.set(34);
        WORD_SEPARATORS.set(39);
        WORD_SEPARATORS.set(36);
        WORD_SEPARATORS.set(61);
        WORD_SEPARATORS.set(38);
        WORD_SEPARATORS.set(47);
        WORD_SEPARATORS.set(126);
    }

    private static final class InsertTabAction
    extends DefaultEditorKit.InsertTabAction {
        private static String tab = "    ";

        private InsertTabAction() {
        }

        private void insertTabAtPosition(JTextComponent jTextComponent, int n) {
            try {
                jTextComponent.getDocument().insertString(n, tab, null);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent == null) {
                return;
            }
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                return;
            }
            tab = RiderEditorKit.getTab(InsertTabAction.tab);
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            if (n2 != n) {
                Element element = jTextComponent.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n2);
                RiderArea riderArea = (RiderArea)jTextComponent;
                riderArea.setSelectionEnd(n);
                riderArea.makeGroupChange(true);
                int n4 = element.getElementIndex(n);
                int n5 = 0;
                do {
                    this.insertTabAtPosition(riderArea, element.getElement(n4).getStartOffset());
                    ++n5;
                } while (n3 != n4++);
                riderArea.makeGroupChange(false);
                riderArea.setSelectionEnd(n2 + n5 * tab.length());
            } else {
                this.insertTabAtPosition(jTextComponent, jTextComponent.getCaretPosition());
            }
        }
    }

    public static final class RemoveTabAction
    extends TextAction {
        private static String tab = "    ";

        public RemoveTabAction() {
            super("RemoveTabAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent == null) {
                return;
            }
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                return;
            }
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            Element element = jTextComponent.getDocument().getDefaultRootElement();
            int n3 = element.getElementIndex(n2);
            RiderArea riderArea = (RiderArea)jTextComponent;
            riderArea.setSelectionEnd(n);
            riderArea.makeGroupChange(true);
            int n4 = element.getElementIndex(n);
            int n5 = 0;
            tab = RiderEditorKit.getTab(RemoveTabAction.tab);
            do {
                Element element2;
                if (!RiderStyles.isImage((element2 = element.getElement(n4)).getElement(0))) continue;
                n5 += this.removeTabAtPosition(riderArea.getDocument(), element2.getStartOffset(), element2.getEndOffset());
            } while (n3 != n4++);
            riderArea.makeGroupChange(false);
            riderArea.setSelectionEnd(n2 - n5);
        }

        private int removeTabAtPosition(Document document, int n, int n2) {
            int n3;
            try {
                String string = document.getText(n, n2 - n);
                int n4 = string.length();
                for (n3 = 0; n3 < n4 && Character.isSpaceChar(string.charAt(n3)) && n3 < tab.length(); ++n3) {
                }
                if (n3 != 0) {
                    document.remove(n, n3);
                }
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
            return n3;
        }
    }
}

