/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.DataDividerManager;
import net.wordrider.core.managers.MenuManager;
import net.wordrider.core.managers.PluginToolsManager;
import net.wordrider.core.managers.StatusbarManager;
import net.wordrider.core.managers.TitleManager;
import net.wordrider.core.managers.ToolbarManager;
import net.wordrider.core.managers.interfaces.IRiderManager;

public final class ManagerDirector
implements IRiderManager {
    private final JPanel rootContainer;
    private AreaManager areaManager;
    private MenuManager menuManager;
    private StatusbarManager statusbarManager;
    private PluginToolsManager pluginsToolManager;
    private final JFrame mainFrame;
    private ToolbarManager toolbarManager;
    private DataDividerManager dataDividerManager;
    private TitleManager titleManager;

    public ManagerDirector(JFrame jFrame, JPanel jPanel) {
        this.mainFrame = jFrame;
        this.rootContainer = jPanel;
        this.init();
    }

    private void init() {
        MainApp.makeProgress();
        this.getMenuManager();
        this.areaManager = new AreaManager(this);
        this.toolbarManager = new ToolbarManager();
        this.pluginsToolManager = new PluginToolsManager();
        this.titleManager = new TitleManager(this.mainFrame);
        this.dataDividerManager = new DataDividerManager(this.rootContainer, this.pluginsToolManager.getManagerComponent(), this.areaManager.getManagerComponent());
        this.getStatusbarManager();
        this.rootContainer.add(this.toolbarManager.getManagerComponent(), "North");
        this.rootContainer.add(this.dataDividerManager.getManagerComponent(), "Center");
        this.rootContainer.add(this.statusbarManager.getManagerComponent(), "South");
        this.areaManager.addAreaChangeListener(this.pluginsToolManager);
        this.areaManager.addAreaChangeListener(this.statusbarManager);
        this.areaManager.addAreaChangeListener(this.menuManager);
        this.areaManager.addAreaChangeListener(this.toolbarManager);
        this.areaManager.addAreaChangeListener(this.titleManager);
        this.areaManager.addFileChangeListener(this.toolbarManager);
        this.areaManager.addFileChangeListener(this.dataDividerManager);
    }

    public DataDividerManager getDataDividerManager() {
        return this.dataDividerManager;
    }

    public final PluginToolsManager getPluginToolsManager() {
        return this.pluginsToolManager;
    }

    public final AreaManager getAreaManager() {
        return this.areaManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager == null ? (this.menuManager = new MenuManager(this)) : this.menuManager;
    }

    public final JFrame getMainFrame() {
        return this.mainFrame;
    }

    public final ToolbarManager getToolbarManager() {
        return this.toolbarManager == null ? (this.toolbarManager = new ToolbarManager()) : this.toolbarManager;
    }

    public final StatusbarManager getStatusbarManager() {
        return this.statusbarManager == null ? (this.statusbarManager = new StatusbarManager()) : this.statusbarManager;
    }

    public final TitleManager getTitleChanger() {
        return this.titleManager;
    }

    public final Component getManagerComponent() {
        return this.rootContainer;
    }

    public void beforeLookAndFeelUpdate() {
        this.getToolbarManager().updateToolbar();
    }

    public void afterLookAndFeelUpdate() {
        this.getPluginToolsManager().lookAndFeelChanged();
    }
}

