/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CompTitledBorder
extends TitledBorder {
    private Component component = null;

    public CompTitledBorder(Component component) {
        this(null, component, 1, 2);
    }

    public CompTitledBorder(Border border) {
        this(border, (Component)null, 1, 2);
    }

    public CompTitledBorder(Component component, Border border) {
        this(border, component, 1, 2);
    }

    private CompTitledBorder(Border border, Component component, int n, int n2) {
        super(border, null, n, n2, null, null);
        this.component = component;
        if (border == null) {
            this.border = super.getBorder();
        }
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Insets insets = this.border != null ? this.border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        Insets insets2 = this.getBorderInsets(component);
        Rectangle rectangle3 = this.getComponentRect(rectangle2, insets2);
        switch (this.titlePosition) {
            case 1: {
                int n5 = rectangle3.height + 2;
                rectangle.y += n5;
                rectangle.height -= n5;
                break;
            }
            case 0: 
            case 2: {
                int n6 = insets2.top / 2 - insets.top - 2;
                rectangle.y += n6;
                rectangle.height -= n6;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int n7 = insets2.bottom / 2 - insets.bottom - 2;
                rectangle.height -= n7;
                break;
            }
            case 6: {
                int n8 = rectangle3.height + 2;
                rectangle.height -= n8;
            }
        }
        this.border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Color color = graphics.getColor();
        graphics.setColor(component.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        graphics.setColor(color);
        this.component.repaint();
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = this.border != null ? this.border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        insets.top = 4 + insets2.top;
        insets.right = 4 + insets2.right;
        insets.bottom = 4 + insets2.bottom;
        insets.left = 4 + insets2.left;
        if (component == null || this.component == null) {
            return insets;
        }
        int n = this.component.getPreferredSize().height;
        switch (this.titlePosition) {
            case 1: {
                insets.top += n + 2;
                break;
            }
            case 0: 
            case 2: {
                insets.top += Math.max(n, insets2.top) - insets2.top;
                break;
            }
            case 3: {
                insets.top += n + 2;
                break;
            }
            case 4: {
                insets.bottom += n + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(n, insets2.bottom) - insets2.bottom;
                break;
            }
            case 6: {
                insets.bottom += n + 2;
            }
        }
        return insets;
    }

    public Component getTitleComponent() {
        return this.component;
    }

    public void setTitleComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public Rectangle getComponentRect(Rectangle rectangle, Insets insets) {
        Dimension dimension = this.component.getPreferredSize();
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        switch (this.titlePosition) {
            case 1: {
                rectangle2.y = 2;
                break;
            }
            case 0: 
            case 2: {
                rectangle2.y = 2 + (insets.top - 2 - 2 - dimension.height) / 2;
                break;
            }
            case 3: {
                rectangle2.y = insets.top - dimension.height - 2;
                break;
            }
            case 4: {
                rectangle2.y = rectangle.height - insets.bottom + 2;
                break;
            }
            case 5: {
                rectangle2.y = rectangle.height - insets.bottom + 2 + (insets.bottom - 2 - 2 - dimension.height) / 2;
                break;
            }
            case 6: {
                rectangle2.y = rectangle.height - dimension.height - 2;
            }
        }
        switch (this.titleJustification) {
            case 0: 
            case 1: {
                rectangle2.x = 5 + insets.left;
                break;
            }
            case 3: {
                rectangle2.x = rectangle.width - insets.right - 5 - rectangle2.width;
                break;
            }
            case 2: {
                rectangle2.x = (rectangle.width - rectangle2.width) / 2;
            }
        }
        return rectangle2;
    }
}

