var sendspace;

$(document).ready(function(){
	sendspace = new sendspaceClass();
	sendspace.init();
	if (document.domain.indexOf('sendspace.com') != -1)
		document.domain = 'sendspace.com';
});

function toggle_parent_sons(a) {
	$(a).parent().parent().find("div").each(function(){
		$(this).toggle();
	});
}

function in_array(value, array) {
	for (var i in array) {
		if (array[i] == value) return true; 
	}
	return false;
}

function remove_from_array(value, array) {
	var new_array = Array();
	for (var i in array) {
		if (array[i] != value) {
			new_array.push(array[i]);
		}
	}
	return new_array;
}

var sendspaceClass = function() {
	
	var self = this;
	var is_ie7 = navigator.userAgent.match(/MSIE 7/);
	
	this.init = function () {
		self.assign_page_events();
	};
	
	this.assign_page_events = function () {

		// input focus event
		$("input").focus(function(){
			$(this).select();
		});
		
		$('.tooltip').hover(
			function(e) {
				this.tip = this.title;
				var content = null;
				var arr = this.tip.split('*');

				if (arr.length > 1) {
					content = '<ul>';
					for (var i = 0; i<arr.length; i++) {
						content = content + '<li>' + arr[i] + '</li>';
					}
					content = content + '</ul>';
				} else content = this.tip;
				
				$(this).append(
					'<div class="tooltipContainer">'
						+'<div class="tooltipContent">'
							+content
						+'</div>'
					+'</div>'
				); 
				this.title = "";
				this.width = $(this).width();
				$(this).find('.tooltipContainer').css({left:this.width-22})
				$('.tooltipContainer').fadeIn(300);
				
			}, function(e) {
				$('.tooltipContainer').fadeOut(100);
				$(this).children().remove();
				this.title = this.tip;
			}
		);
		// tooltip event
		$(".tooltip_holder").hover(function(){
			$("#content .tooltip").hide();
			$(this).find(".tooltip").fadeIn("normal");
		}, function(){
			$(this).find(".tooltip").fadeOut("normal");
		});
		
		// clear first input event
		$("input.clear_first").focus(function(){
			if (typeof($(this).data("first")) == "undefined") {
				$(this).val("").css({color: "#222"});
				$(this).data("first", 1);
			}
		});
		
		// login frame event
		var $login_frame = $("#login_frame");
		$("a.login").click(function(e){
			var rel = $(this).attr("rel");
			if (rel == "open") 
			{
				/*
				if ($.browser.msie) 
					$login_frame.show();
				else 
					$login_frame.fadeIn("normal");
				*/
				$login_frame.show();
				$("#top_login_username").focus();
				if ($('#mobile_upload_page').length)
					$('#login_frame ul.options li a').show();
				self.overlay.show();
				return false;
			}
			self.overlay.hide();
			return false;
		});
		
		this.overlay = new function() {
			var self = this;
			var $glass = $("#glass");
			this.show = function() {
				 if (!is_ie7) $glass.show();
			};
			
			this.hide = function() {
				if ($.browser.msie)
					$("div.overlay").hide();
				else $("div.overlay").fadeOut("fast");
				if (!is_ie7) $glass.hide();
				
				if ($('.openid-popup').length)
					$('.openid-popup').hide();
			
			};
			
			$glass.click(function(){
				self.hide();
			});
		}
		
		// link copy event
		$("a.copy.selectable").click(function() {
			var $link = $("<input/>")
							.addClass("file_url")
							.attr({"type": "text", "readonly": "readonly"})
							.val($("a.link").text());
			$("a.link.selectable").replaceWith($link);
			self.assign_page_events();
			$link.focus().select();
		});
	};
	
	// Define uploader UI
	if ($("#progress_bar").length > 0) 
	{
		this.progress = new function () 
		{
			//focus
			var $progress = $("#progress_bar");
			var w = $progress.find(".bar").width();
			var $stats = $progress.find(".stats");
			
			var backupTitle = ''; //parent.document.title;
			
			
			this.restoreTitle = function() {
				parent.document.title = backupTitle;
			};
			
			this.update = function (params) 
			{
				this.move(params[0]);
				this.stats(params);
			};
			
			this.move = function (to) 
			{			
				try
				{
				
					var to_bar = to >= 100 ? 99 : to;
					
					$progress
						.find(".fill")
						.animate({width: to_bar+"%"}, 100);
					var w = $("#progress_bar").find(".bar").width();
					var val = w*to/100;
					if (val > 0)
					{
						$progress
							.find(".tag")
							.text(to+"%")
							.animate({left: (val-19)+"px"} , 100);
					}
					
					parent.document.title = 'Upload ' + to + '% done';
				}
				catch (e) { }
			};
			
			this.stats = function (params) 
			{
				try
				{
					$stats.find(".time_left").text(params[1]);
					$stats.find(".elapsed span").text(params[2]);
					$stats.find(".data").text(params[3]);
					$stats.find(".total").text(params[4]);
					$stats.find(".kbps").text(((Math.round(params[5] * 1024 * 8)) / 1000) + 'kbps' + ' (' + params[5] + 'KB/s)');
				}
				catch (e) { }
			};
		};
	};
};