#!/bin/sh
# FRD requires Sun Java 6, NO Shity GCJ, NO buggy OpenJDK, but Sun Java 6!
# some crappy distros needed to add switch -Djava.net.preferIPv4Stack=true 

# Created by Petris 2009 -> Many thanks!

# Modified by Ctojko 2013
# Modifications -> Petris made script that check for java version witch could not be below 1.6.0_5
# Ctojko turn it up side down, added check for latest versions of java available on system for FRD to use
# added command line argument (for help type in shell "frd.sh -h" or "frd.sh --help")
# to make FRD uses version that we say in command line argument to use.
# and updated LOOKUP_JRE_DIRS with "/usr/java/*" cause on some systems java could be hiding in there ;)

# Look for java in these directories
LOOKUP_JRE_DIRS="/usr/lib/jvm/* /opt/java* /opt/jre* /usr/java/*"

# Handle symlinks
PROGRAM="$0"
while [ -L "$PROGRAM" ]; do
	PROGRAM=`readlink -f "$PROGRAM"`
done
cd "`dirname \"$PROGRAM\"`"

# Locate and run FRD vith requested or latest java
locate_and_run () {
for JRE_PATH in $LOOKUP_JRE_DIRS; do
	if [ -x "$JRE_PATH/bin/java" ]; then
		JAVA_VERSION_OUTPUT=`"$JRE_PATH/bin/java" -version 2>&1`
		check_java_version && {
			export JRE_PATH
			exec $JRE_PATH/bin/java -Djava.net.preferIPv4Stack=true -Xmx160m -jar frd.jar "$@"
		}
	fi
done

# If requested java culd not be found on the system
failed_req
}

latest_java_version () {
	FOUND_JAVA_VER=`echo $JAVA_VERSION_OUTPUT | sed 's/java version "\([0-9]*\.[0-9]*\.[0-9]*_[0-9]*\)".*/\1/'`
	JVER_ALL=${FOUND_JAVA_VER//./}
	JVER_V=${JVER_ALL%_*}
	JVER_U=${JVER_ALL#*_}

	if [ $JVER_V -gt $LATEST_JVER_V ]; then
		LATEST_JVER_V=$JVER_V
		LATEST_JVER_U=$JVER_U
	elif [ $JVER_V -eq $LATEST_JVER_V ] && [ $JVER_U -gt $LATEST_JVER_U ]; then
		LATEST_JVER_U=$JVER_U
	fi

	if [ $JVER_V -eq $LATEST_JVER_V ] && [ $JVER_U -eq $LATEST_JVER_U ]; then
		return 0
	else
		return 1
	fi
}

check_java_version () {
	FOUND_JAVA_VER=`echo $JAVA_VERSION_OUTPUT | sed 's/java version "\([0-9]*\.[0-9]*\.[0-9]*_[0-9]*\)".*/\1/'`
	JVER_ALL=${FOUND_JAVA_VER//./}
	JVER_V=${JVER_ALL%_*}
	JVER_U=${JVER_ALL#*_}

	if [ $JVER_V -eq $LATEST_JVER_V ] && [ $JVER_U -eq $LATEST_JVER_U ]; then
		return 0
	else
		return 1
	fi
}

failed_req () {
if [ -x "`which xmessage`" ]; then
	xmessage -nearmouse -file - <<EOF 
Failed to find a suitable java version.
Required: $REQUIRED_JVER
Found:$FOUND_JAVA_VER

EOF
else
	echo "Failed to find a suitable java version."
	echo "Required: $REQUIRED_JVER or newer."
	echo "Found: $FOUND_JAVA_VER"
fi

exit 1
}

f_one () {
	echo
	echo "Usage:"
	echo "  $0 [OPTION]"
	echo "  if there is no [OPTION] then use latest java vesion found on system"
	echo
	echo "Options:"
	echo "-h, --help         show this help, then exit"
	echo "-u, --use          Use java version {N.N.N_N}"
	echo
	echo $ERROR_MSG
	echo
    exit 1
}

# Check default java
check_def () {
if [ -x "`which java`" ]; then
	JAVA_VERSION_OUTPUT=`java -version 2>&1`
	latest_java_version && exec java -Djava.net.preferIPv4Stack=true -Xmx160m -jar frd.jar "$@"
fi

# If is not default java version the latest then use the latest where ever it is ;)
locate_and_run
}

# Test all possible Java locations for latest java version
locate_latest () {
	for JRE_PATH in $LOOKUP_JRE_DIRS; do
	if [ -x "$JRE_PATH/bin/java" ]; then
		JAVA_VERSION_OUTPUT=`"$JRE_PATH/bin/java" -version 2>&1`
		latest_java_version
	fi
done

# Check default java version for latest
check_def
}

OPTION=${1}
USE_JAVA_VER=${2}

# Check is there string for java version to use
if [ -z "${OPTION}" ]; then
	# Defines minimum required version if there is no strig
	REQUIRED_JVER="1.6.0_5"
	REQ_JVER_ALL=${REQUIRED_JVER//./}
	LATEST_JVER_V=${REQ_JVER_ALL%_*}
	LATEST_JVER_U=${REQ_JVER_ALL#*_}
	locate_latest
	else
		# Check for -h or --help string
		if [ "${OPTION}" = '-h' -o "${OPTION}" = '--help' ]; then
		ERROR_MSG=""
		f_one
		elif [ "${OPTION}" = '-u' -o "${OPTION}" = '--use' ]; then
		REQUIRED_JVER="$USE_JAVA_VER"
		USE_JVER_ALL=${REQUIRED_JVER//./}
		LATEST_JVER_V=${USE_JVER_ALL%_*}
		LATEST_JVER_U=${USE_JVER_ALL#*_}
		locate_and_run
		else
		ERROR_MSG="and you entered ${*}"
		f_one
		fi
fi
