package cz.vity.freerapid.plugins.services.luxport;

import cz.vity.freerapid.plugins.exceptions.ErrorDuringDownloadingException;
import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.exceptions.ServiceConnectionProblemException;
import cz.vity.freerapid.plugins.exceptions.URLNotAvailableAnymoreException;
import cz.vity.freerapid.plugins.webclient.AbstractRunner;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/**
 * Class which contains main code
 *
 * @author Vity
 */
class LuxportFileRunner extends AbstractRunner {
    private final static Logger logger = Logger.getLogger(LuxportFileRunner.class.getName());


    @Override
    public void runCheck() throws Exception { //this method validates file
        super.runCheck();
        final GetMethod getMethod = getGetMethod(fileURL);//make first request
        ;
        if (makeRedirectedRequest(getMethod)) {
            checkNameAndSize(getContentAsString());//ok let's extract file name and size from the page
        } else
            throw new PluginImplementationException();
    }

    private void checkNameAndSize(String content) throws ErrorDuringDownloadingException {
        //if content-language=en
        PlugUtils.checkName(httpFile, content, "<h1>", "</h1>");
        //add changes to plugin
        //PlugUtils.checkFileSize(httpFile, content, "total size: ", ", <a ");

        httpFile.setFileState(FileState.CHECKED_AND_EXISTING);
    }

    @Override
    public void run() throws Exception {
        //GREAT THANKS TO @ntoskrnl for his help!!!
        super.run();
        logger.info("Starting download in TASK " + fileURL);
        GetMethod getMethod = getGetMethod(fileURL);

        if (makeRedirectedRequest(getMethod)) {
            String url_list_link = "http://luxport.ru/filelist" + getMethod.getPath().substring(5) + ".urls";

            List<URI> urls = readUrlContents(url_list_link);

            if (urls.isEmpty()) throw new PluginImplementationException("No files found");

            synchronized (getPluginService().getPluginContext().getQueueSupport()) {
                getPluginService().getPluginContext().getQueueSupport().addLinksToQueue(httpFile, urls);
            }
        }
        
        else {
            checkProblems();
            throw new ServiceConnectionProblemException();
        }
    }

    private List<java.net.URI> readUrlContents(String _url) throws IOException, URISyntaxException {
        URL url = new URL(_url); //"http://luxport.ru/filelist/1472838.urls"
        BufferedReader in = new BufferedReader(
                new InputStreamReader(
                        url.openStream()));

        String inputLine;
        List<URI> list = new ArrayList<URI>();
        while ((inputLine = in.readLine()) != null) {
            list.add(new URI(inputLine));
        }
        in.close();

        return list;
    }

    private void checkProblems() throws ErrorDuringDownloadingException {
        final String contentAsString = getContentAsString();
        if (contentAsString.contains("\u0424\u0430\u0439\u043B \u043D\u0435 \u043D\u0430\u0439\u0434\u0435\u043D")) {
            throw new URLNotAvailableAnymoreException("Url is not avaible any more");
        }

        if (contentAsString.contains("\u0422\u0430\u043A\u043E\u0439 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u044B \u043D\u0430 \u043D\u0430\u0448\u0435\u043C \u0441\u0430\u0439\u0442\u0435 \u043D\u0435\u0442")) {
            throw new URLNotAvailableAnymoreException("File not found"); //let to know user in FRD
        }

        if (contentAsString.contains("File Not Found")) {
            throw new URLNotAvailableAnymoreException("File not found"); //let to know user in FRD
        }
    }
}
