package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.UserProp;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;


/**
 * @author birchie
 */
public final class SchedulerManager {
    private final static Logger logger = Logger.getLogger(SchedulerManager.class.getName());
    private Timer timer;

    final long interval = 15;//seconds


    public SchedulerManager() {
    }
    public void initManager(){
        initSchedulerTimer();
    }
    public void initSchedulerTimer() {
        Calendar scheduleTime = Calendar.getInstance();
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer("ScheduleTimer");
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                if (isEnabled())
                    checkAndExecute();
            }
        }, scheduleTime.getTime(), interval * 1000);
    }

    public boolean isEnabled() {
        return AppPrefs.getProperty(UserProp.SCHEDULER_ENABLED, UserProp.SCHEDULER_ENABLED_DEFAULT);
    }

    public void setEnabled(final boolean enabled) {
        AppPrefs.storeProperty(UserProp.SCHEDULER_ENABLED, enabled);
    }

    public void checkAndExecute() {
        if (this.isEnabled()) {
            final String schedule = AppPrefs.getProperty(UserProp.SCHEDULER_TIMES, UserProp.SCHEDULER_TIMES_DEFAULT);

            final String nextActionTime = schedule.split(",",2)[0];
            final String restActionTime = schedule.split(",",2)[1];
            if (nextActionTime.trim().equalsIgnoreCase("X")) {   // disable the scheduler
                AppPrefs.storeProperty(UserProp.SCHEDULER_TIMES ,restActionTime+","+nextActionTime);
                logger.info("Scheduler state = DISABLE");
                setEnabled(false);
            } else {
                 try {
                    final int currentTime[] = this.getCurrentTimeHMS();
                    final String nextHourMin[] = nextActionTime.trim().split("\\D+");
                    final int nextMin = Integer.parseInt(nextHourMin[nextHourMin.length-1]);
                    final int nextHour = Integer.parseInt(nextHourMin[nextHourMin.length-2]);
                    final String nextAction = nextActionTime.trim().split("\\d+")[0];
                    logger.info("Scheduler current time = "+currentTime[0]+":"+currentTime[1]+"; next scheduled time = "+nextHour+":"+nextMin);
                    if ((currentTime[0]==nextHour) && (currentTime[1]==nextMin)) {
                        AppPrefs.storeProperty(UserProp.SCHEDULER_TIMES ,restActionTime+","+nextActionTime);
                        if (nextAction.equals("-")) {
                            logger.info("Scheduler action = STOP");
                            AppPrefs.storeProperty(UserProp.STOP_AUTO_QUEUE, true);
                        } else if (nextAction.equals("+")) {
                            logger.info("Scheduler action = START");
                            AppPrefs.storeProperty(UserProp.STOP_AUTO_QUEUE, false);
                        } else {
                            logger.info("Scheduler action = TOGGLE");
                            AppPrefs.negateProperty(UserProp.STOP_AUTO_QUEUE,UserProp.STOP_AUTO_QUEUE_DEFAULT);
                        }
                    }
                } catch (Exception err) {   // invalid time
                    logger.info("Scheduler ignoring ERROR");
                    AppPrefs.storeProperty(UserProp.SCHEDULER_TIMES ,restActionTime);
                }
            }

        }
    }
    public int[] getCurrentTimeHMS() {
        final int currentTimeSec = (int) System.currentTimeMillis() / 1000;
        final int currentTimeMin = (currentTimeSec / 60) + AppPrefs.getProperty(UserProp.SCHEDULER_TIMEZONE_CORRECTION, UserProp.SCHEDULER_TIMEZONE_CORRECTION_DEFAULT);
        final int currentTimeHour = currentTimeMin / 60;
        int output[] = new int[3];
        output[0] = currentTimeHour - (currentTimeHour/24)*24;
        output[1] = currentTimeMin - (currentTimeMin/60)*60;
        output[2] = currentTimeSec - (currentTimeSec/60)*60;
        return output;
    }
}