
#include "mkhibview.h"


short iscomp(HANDLE h) {
  return (h_getCompTag(h_getFileType(HeapDeref(h))) == ZIP_TAG);
}

HANDLE uncomp(short id, HANDLE h) {
  
  if (id != TRUE) {
    return H_NULL;
  }
  
  unsigned char * data = HLock(h);
  if (data == NULL) {
    return H_NULL;
  }
  
  data+=4;
  
  unsigned short size = ziplib_eval_emem(data);
  
  HANDLE h_uncomp = HeapAlloc(size+2);
  if (h_uncomp == H_NULL)
  {
    HeapUnlock(h);
    return H_NULL;
  }
  
  unsigned char * data_uncomp = HLock(h_uncomp);
  
  if (data_uncomp == NULL) {
    HeapFree(h_uncomp);
    HeapUnlock(h);
    return H_NULL;
  }
  *(unsigned short *)data_uncomp = size;
  data_uncomp +=2;
  
  short ret = ziplib_extract(data, data_uncomp);
  
  //TODO no doc about possible ret values...
  
  return h_uncomp;
}
