
#include "mkhibview.h"

#define NB_OPTION             3

#define NUM_OPTION_DRAWSIZE         0
#define NUM_OPTION_ALLOWBIGOBJECT   1
#define NUM_OPTION_ZOOM             2

void loadConfig(hVCfg * config)
{
  short error;
  config->drawSize = conflib__get_num_key("hibconf", "general", "drawSize", 0, &error);
  config->allowBigObject = conflib__get_num_key("hibconf", "general", "allowBigObject", TRUE, &error);
  config->zoom = conflib__get_num_key("hibconf", "general", "zoom", 1, &error);
  //TODO mabe handle some error
}

void saveConfig(hVCfg * config)
{
  short error;
  error = conflib__add_num_key("hibconf", "general", "drawSize", config->drawSize);
  error = conflib__add_num_key("hibconf", "general", "allowBigObject", config->allowBigObject);
  error = conflib__add_num_key("hibconf", "general", "zoom", config->zoom);
  //TODO mabe handle some error
}


struct datas {
  const unsigned char * * texts;
  h_Menu * hmenus;
};

//fonction wich will be used for the h_Menu
void fct_draw_option(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {
  struct datas * datas = (struct datas *) hmenu->datas;
  hl_drawStr(hmenu->font, x, y, datas->texts[i], FALSE, FALSE, screen);
  if (hmenu->no_choice == i) {
    hl_drawMenu(&(datas->hmenus[i]), LCD_SCREEN);
  }
}


void optionMenu(h_Menu * hmenu, short * value, h_Config * hcfg) {
  hmenu->no_choice = *value;
draw:
  hl_drawMenu(hmenu, LCD_SCREEN);
  do {
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(hmenu);
      } else {
        hl_goMenuDown(hmenu);
      }
      goto draw;
    } else if (K_UP) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(hmenu);
      } else {
        hl_goMenuUp(hmenu);
      }
      goto draw;
    } else if (K_ENTER) {  //[ENTER] : the choice is done
      h_startSynchro(hcfg->speed_key);
      *value = hmenu->no_choice;
      return;
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(hcfg->speed_key);
      return;
    } else if (K_CLEAR) {  //[CLEAR]: turn the calculator off
      off();
      h_startSynchro(hcfg->speed_key);
    } else if (K_PLUS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastDn();
    } else {
      h_saveEnergy();
    }
  } while (TRUE);

}

void redrawScreen(h_Config * hcfg, BOOL isValue, h_Menu * hmenu, h_Menu * hmenu_option)
{
  clrscr();
  h_drawFrame(0, 0, LCD_WIDTH - 1, 9, LCD_SCREEN);
  h_drawFrame(0, 9, LCD_WIDTH - 1, LCD_HEIGHT / 2 + 4, LCD_SCREEN);
  h_drawFrame(0, LCD_HEIGHT / 2 + 4, LCD_WIDTH - 1, LCD_HEIGHT - 1, LCD_SCREEN);
  hl_drawStr(hcfg->font_msg, (LCD_WIDTH - TXTLEN1_OPTION_TITLE) / 2, 2, TXT_OPTION_TITLE, FALSE, FALSE, LCD_SCREEN);
  if (isValue)
  {
  	  h_drawFrame(3, LCD_HEIGHT / 2 + 7, LCD_WIDTH - 4, LCD_HEIGHT - 4, LCD_SCREEN);
  }
  else
  {
  	  h_drawFrame(3, 12, LCD_WIDTH - 3, LCD_HEIGHT / 2 + 1, LCD_SCREEN);
  }
  hl_drawMenu(hmenu, LCD_SCREEN);
}

void optionsMenu(hVCfg * config, h_Config * hcfg) {
  
  h_Menu hmenu_option = {
    .nb = 0,
    .size_item = 0,
    .tab = NULL,
    .level_tab = NULL,
    .pos_x = 8,
    .pos_y = LCD_HEIGHT / 2 + 12,
    .width = LCD_WIDTH - 16,
    .nb_draw = (CALCULATOR ? 7 : 5),
    .font = hcfg->font_msg,
    .no_choice = 0,
    .top = 0,
    .move = 0,
    .fct_draw = NULL,
    .draw_scrollbar = FALSE
  };
  
  h_Menu hsubmenus[NB_OPTION];
  
  hmenu_option.nb = 3;
  hmenu_option.no_choice = config->drawSize;
  hmenu_option.tab = (unsigned char *)((const unsigned char * []){TXT_OPTION_DRAWSIZE_SCREEN, (CALCULATOR ? TXT_OPTION_DRAWSIZE_89 : TXT_OPTION_DRAWSIZE_92), TXT_OPTION_DRAWSIZE_MAX});
  hsubmenus[NUM_OPTION_DRAWSIZE] = hmenu_option;
  
  hmenu_option.nb = 2;
  hmenu_option.no_choice = config->allowBigObject;
  hmenu_option.tab = (unsigned char *)((const unsigned char * []){TXT_NO, TXT_YES});
  hsubmenus[NUM_OPTION_ALLOWBIGOBJECT] = hmenu_option;
  
  hmenu_option.nb = 3;
  hmenu_option.no_choice = config->zoom;
  hmenu_option.tab = (unsigned char *)((const unsigned char * []){TXT_OPTION_ZOOM_LITTLE, TXT_OPTION_ZOOM_NORMAL, TXT_OPTION_ZOOM_BIG});
  hsubmenus[NUM_OPTION_ZOOM] = hmenu_option;
  
  struct datas datas = {
    .texts = (const unsigned char * []){TXT_OPTION_DRAWSIZE, TXT_OPTION_ALLOWBIGOBJECT, TXT_OPTION_ZOOM},
    .hmenus = hsubmenus
  };
    
  h_Menu hmenu = {
    .nb = NB_OPTION,
    .size_item = 0,
    .tab = NULL,
    .level_tab = NULL,
    .datas = &datas,
    .pos_x = 8,
    .pos_y = 16,
    .width = LCD_WIDTH - 16,
    .nb_draw = (CALCULATOR ? 7 : 5),
    .font = hcfg->font_msg,
    .no_choice = 0,
    .top = 0,
    .move = 0,
    .fct_draw = fct_draw_option,
    .draw_scrollbar = FALSE
  };
  
  redrawScreen(hcfg, FALSE, &hmenu, hsubmenus + hmenu.no_choice);
    
draw:
  hl_drawMenu(&hmenu, LCD_SCREEN);
  do {
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(&hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(&hmenu);
      } else {
        hl_goMenuDown(&hmenu);
      }
      goto draw;
    } else if (K_UP) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(&hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(&hmenu);
      } else {
        hl_goMenuUp(&hmenu);
      }
      goto draw;
    } else if (K_ENTER) {  //[ENTER] : the choice is done
      h_startSynchro(hcfg->speed_key);
	    redrawScreen(hcfg, TRUE, &hmenu, hsubmenus + hmenu.no_choice);
      short * value = NULL;
      switch (hmenu.no_choice)
      {
        case NUM_OPTION_DRAWSIZE:
          value = &(config->drawSize);
          break;
        case NUM_OPTION_ALLOWBIGOBJECT:
          value = &(config->allowBigObject);
          break;
        case NUM_OPTION_ZOOM:
          value = &(config->zoom);
          break;
      }
    optionMenu(hsubmenus + hmenu.no_choice, value, hcfg);
	  redrawScreen(hcfg, FALSE, &hmenu, hsubmenus + hmenu.no_choice);
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(hcfg->speed_key);
      return;
    } else if (K_CLEAR) {  //[CLEAR]: turn the calculator off
      off();
      h_startSynchro(hcfg->speed_key);
    } else if (K_PLUS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastDn();
    } else {
      h_saveEnergy();
    }
  } while (TRUE);
  
}

