
#include "mkhibview.h"

void __main(void) {

  void * savescreen = NULL;  //save the home screen
  const unsigned char * end_message = TXT_END_MESSAGE;  //the message to show in status bar at the end
  h_Font * fonttab;
  h_Font * bigfonttab;
  h_Font * littlefonttab;
  h_Font * fonttabs[3];
  short nb_font;
  h_Font * font_message;
  h_File hfile;
  unsigned char name_var[20];
  HSym hsym;
  short bookmark=-1;
  short lcdwidth = LCD_WIDTH;
  ESI           argptr;
  unsigned char argtype;
  const unsigned char * str;
  h_Code hcode;
  h_Menu hmenu;
  HANDLE h;
  HANDLE h_level;
  BOOL b;
  short key;
  BOOL gomenu = FALSE;
  hVCfg config;

	h_I18nLog i18nlog = HTEXT_HI18N_LOG;
	h_I18nLink i18nlink = HTEXT_HI18N_LINK;
	h_I18nBookmark i18nbookmark = HTEXT_HI18N_BOOKMARK;
  FontSetSys(F_4x6);
  
  loadConfig(&config);
    
   savescreen=malloc(LCD_SIZE);
  if (savescreen == NULL) {
    end_message = TXT_ERR_MEM;
    goto end;
  }
//save the screen
  memcpy(savescreen, LCD_MEM, LCD_SIZE);
	
	clrscr();
  
	//load every font in the Ti
  nb_font = hl_loadAllFont(&fonttab);
  if (nb_font == NOK) {
    end_message = TXT_ERR_LOAD_FONT;
    goto end_savescreen;
  }

  bigfonttab = h_setBigFont(fonttab, nb_font);
  if (bigfonttab == NULL) {
    end_message = TXT_ERR_LOAD_FONT;
    goto font;
  }

  littlefonttab = h_setLittleFont(fonttab, nb_font);
  if (littlefonttab == NULL) {
    end_message = TXT_ERR_LOAD_FONT;
    goto bigfont;
  }

  fonttabs[0] = littlefonttab;
  fonttabs[1] = fonttab;
  fonttabs[2] = bigfonttab;

  //load the font for the messages
  font_message = hl_findFont("tios1", fonttab, nb_font);

  h_Config hcfg = {
    .font_msg = font_message,
    .speed_scroll = 0,
    .speed_key = SPEED_KEY
  };

//search the text to show
  InitArgPtr(argptr);//=top_estack;
  argtype = GetArgType(argptr);
	
  if (argtype == STR_TAG) {  //a string in parameter

    str = GetStrnArg(argptr);
    if (*str != '#') {  // a name of a file
      if (strlen(str) > 18) { //impossible to have a name of file bigger than 18
        end_message = TXT_ERR_TAPE;
        goto quit;
      }

      hsym=SymFind(SYMSTR(str));  //search the file
var:
      if (hsym.folder==H_NULL) {  //not found
        h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_ERR_TEXT_NOT_FIND}, 1);
        ngetchx();
        goto quit;
      }
      h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_LOADING}, 1);
      switch (config.drawSize)
      {
      	case 0:
          lcdwidth = LCD_WIDTH;
          break;
        case 1:
          lcdwidth = (CALCULATOR ? 160 : 240);
          break;
        case 2:
          lcdwidth = -1;
          break;
      }
      hcode = h_loadHSym(&hfile, hsym, lcdwidth, config.allowBigObject, fonttabs[config.zoom], nb_font, iscomp, uncomp);
      switch (hcode) {
        case HCODE_ERR_MEM :
          h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_ERR_MEM}, 1);
          ngetchx();
          goto quit;
        case HCODE_ERR_WRONG_TYPE : 
          h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_ERR_WRONG_TYPE}, 1);
          ngetchx();
          goto quit;
        case HCODE_NO_ERR :
          break;
      }
    } else {
  
    //we have entered codes beginning by #
      if (str[1] == 'A') {
      //  draw_about();
        goto quit;
      } else if (str[1] != 'T') {
        end_message = TXT_ERR_TAPE;
        goto quit;
      }
      
      str += 2;
      //a text entered in parameter
      h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_LOADING, TXT_PARSING}, 2);
      if (!hl_parse(&hfile, str, strlen(str))) {
        end_message = TXT_ERR_MEM;
        goto quit;
      }
      h_drawMessage(font_message, TXT_HIBVIEW_TITLE, (const unsigned char * []){TXT_LOADING, TXT_LAYOUT}, 2);
      if (!hl_layout(&hfile, LCD_WIDTH, config.allowBigObject, fonttab, nb_font, iscomp, uncomp)) {
        end_message = TXT_ERR_MEM;
        goto quit;
      }
    }
  } else {//no parameter
start_menu:
    gomenu = TRUE;
    b = h_initMenuVAT(&hmenu, font_message, 5, 12, LCD_WIDTH - 10, (LCD_HEIGHT - 15) / 6, &h, &h_level, /*h_hibfilterVAT*/NULL, h_drawVAT);
    if (!b)
    {
      end_message = TXT_ERR_INITVAT;
      goto quit;
    }
menu:
    h_initSynchro(hcfg.speed_key);
menu_redraw:
    clrscr();
    h_drawFrame(0, 0, LCD_WIDTH - 1, 9, LCD_SCREEN);
    h_drawFrame(0, 9, LCD_WIDTH - 1, LCD_HEIGHT - 1, LCD_SCREEN);
    hl_drawStr(font_message, (LCD_WIDTH-TXTLEN1_HIBVIEW_TITLE) / 2, 2, TXT_HIBVIEW_TITLE, FALSE, FALSE, LCD_SCREEN);
menu_draw:
    hl_drawMenu(&hmenu, LCD_SCREEN);
menu_key:
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg.speed_key);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(&hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(&hmenu);
      } else {
        hl_goMenuDown(&hmenu);
      }
      goto menu_draw;
    } else if (K_UP) {
      h_startSynchro(hcfg.speed_key);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(&hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(&hmenu);
      } else {
        hl_goMenuUp(&hmenu);
      }
      goto menu_draw;
    } else if (K_RIGHT) {
      h_startSynchro(hcfg.speed_key);
      hl_goSubMenu(&hmenu);
      goto menu_draw;
    } else if (K_LEFT) {
      h_startSynchro(hcfg.speed_key);
      hl_goUpperMenu(&hmenu);
      goto menu_draw;
    } else if (K_ENTER) {  //[ENTER] : the choice is done
      h_startSynchro(hcfg.speed_key);
      hsym = ((HSym *)hmenu.tab)[hmenu.no_choice];
      if (DerefSym(hsym)->flags.bits.folder)
        goto menu_key;
      h_waitSynchro();
      h_freeSynchro();
      goto var;
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(hcfg.speed_key);
      h_waitSynchro();
      h_freeSynchro();
      goto quit;
    } else if (K_CLEAR) {  //[CLEAR]: turn the calculator off
      h_startSynchro(hcfg.speed_key);
      off();
    } else if (K_PLUS && K_DIAM) {
      h_startSynchro(hcfg.speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg.speed_key);
      OSContrastDn();
    } else if (K_F5) {
      optionsMenu(&config, &hcfg);
      saveConfig(&config);
      goto menu_redraw;
    } else {
      h_saveEnergy();
    }
    goto menu_key;
  }
  hl_setScreen(&hfile, LCD_MEM, 0, 0, LCD_WIDTH, LCD_HEIGHT);
    
#ifdef DRAW_LOG
  if (hfile.nb_logs!=0)
  {
    h_logMenu(&hfile, &hcfg, &i18nlog);
  }
#endif
  if (h_isPic((&hfile)))
  {
    key = h_readPic(&hfile, &hcfg);
  }
  else
  {
    key = h_readhFile(0, &bookmark, name_var, &hfile, &hcfg, &i18nbookmark, &i18nlink);
  }
  hl_freehFile(&hfile);
  if (key == HKEY_NEW_FILE) {
    hsym = SymFind(name_var + strlen(name_var + 1) + 1);
    goto var;
  }
#ifdef ALWAYS_RETURN_TO_MENU
  if (gomenu) {
  	goto menu;
  }
  goto start_menu;
#else
  if (gomenu)
    goto menu;
#endif
quit:
  if (gomenu) {
    HeapFree(h);
    HeapFree(h_level);
  }
  free(littlefonttab);
bigfont:
  free(bigfonttab);
font:
  hl_unloadAllFont(fonttab, nb_font);
end_savescreen:
  memcpy(LCD_MEM, savescreen, LCD_SIZE);  //restore the home screen
  free(savescreen);
end:
  //h_restoreScreen(); unstable!!
  ST_helpMsg(end_message);
}


