
#include "mkhibliba.h"

/**
 * Load a file with the HSym
 * It can open HTXT, TEXT, PIC and STR files
 *
 * @param hfile the h_File to fill
 * @param hsym the HSym of the file to load
 * @param line_width_max the maximum width of a lien of text (-1 for infinite)
 * @param fonttab the table of every font
 * @param nb_font the number of font
 * @param iscomp the function that return if a data is compressed or not
 * @param uncomp the function that uncompressed datas
 *
 * @return a h_Code saying it is successfull or not
 */
void h_loadPic(h_File * hfile, HANDLE h, BITMAP * data, FctIsComp iscomp, FctUnComp uncomp) {
  
  *hfile = (h_File) {
    .isPic = TRUE,
    .text = NULL,
    .size_text = 0,
    .hh = (h_Header) {
      .pos_name_font = {NOK, NOK, NOK, NOK, NOK, NOK, NOK, NOK, NOK, NOK},
      .pos_title = NOK,
      .pos_author = NOK,
      .pos_date = NOK,
      .pos_comment=NOK
    },
    .nb_targetlinks = 0,
    .nb_tioslines = 0,
    .nb_objs = 0,
    .h_objs = H_NULL,
    .hobjs = NULL,
    .nb_logs = 0,
    .h_logs = H_NULL,
    .hlogs = NULL,
    .nb_bkmks = 0,
    .h_bkmks = H_NULL,
    .hbkmks = NULL,
    .h_bkmks_level = H_NULL,
    .hbkmks_level = NULL,
    .fontptr = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL},
    .nb_scrlines = 0,
    .h_scrlines = H_NULL,
    .hscrlines = NULL,
    .nb_links = 0,
    .h_links = H_NULL,
    .hlinks = NULL,
    .iscomp = iscomp,
    .uncomp = uncomp,
    .fonttab = NULL,
    .nb_font = 0,
    .linewidth = 0,

    .h_buffer = H_NULL,
    .buffer = (h_Screen) {
      .mem = (h_ScreenMem) {
        .ptr = data->Data,
        .byte_width = ((data->NumCols + 7) >> 3)
      },
      .size = (h_ScreenSize) {
        .width = data->NumCols,
        .height = data->NumRows
      },
      .pos = (h_ScreenPos) {
        .x = 0,
        .y = 0
      },
    },
    .drawn_height = data->NumRows,
  
    .line_top = 0,
    .line_bot = 0,

    .x_offset = 0
  };
  
}
