
#include "mkhibliba.h"

/**
 * Resize a handle of a table
 *
 * @param h the handle
 * @param newsize the new size of the handle
 * @param size the size of the handle
 * @param nb the number of item in the table
 * @param sizeitem the size of the item in the table
 *
 * @return FALSE in case of memory error, else TRUE
 */
BOOL h_resizeHANDLE(HANDLE * h, short newsize, short * size, short * nb, short size_item) {
  HANDLE h2 = HeapRealloc(*h, newsize * size_item);
  if (h2 == H_NULL) {
    return FALSE;
  }
  *size = newsize;
  *h = h2;
  if (*nb > *size) {
    *nb = *size;
  }
  return TRUE;
}
