// C Source File
// Created 10/11/2003; 23:11:05


#include "mktest.h"

/*===============================================================================================
== test
===============================================================================================*/
void test_read(const unsigned char * text, const unsigned char * title, short width, short x, short y, short lcdwidth, short lcdheight) {
  h_File hfile;
  BOOL errparse;
  BOOL errlayout;
  h_Config hcfg;
  short bookmark=-1;
  unsigned char name_var[20];
  h_Font * fonttab = NULL;
  h_I18nLink hi18nlink = HI18N_LINK_FR;
  h_I18nBookmark hi18nbookmark = HI18N_BOOKMARK_FR;
  begintest("Read",title);
  
  short nb_font = hl_loadAllFont(&fonttab);
  
  hcfg = (h_Config) {
    .font_msg=hl_findFont("tios1",fonttab,nb_font),
    .speed_scroll=SPEED_SCROLL,
    .speed_key=SPEED_KEY,
  };
  
  clrscr();
  errparse=hl_parse(&hfile,text,strlen(text));
  errlayout=hl_layout(&hfile,width,FALSE,fonttab,nb_font,NULL,NULL);
  hl_initScreen(&hfile,LCD_MEM,x,y,lcdwidth,lcdheight);
  h_readhFile(0,&bookmark,name_var,&hfile,&hcfg, &hi18nbookmark, &hi18nlink);
  hl_freehFile(&hfile);
  
  hl_unloadAllFont(fonttab,nb_font);
  
  finishtest();
}




