/**
 * Here are the different translation of the hibLib texts
 * 
 * FR : french by Nicolas Laleve
 * EN : english by Nicolas Laleve
 * PT : portuguese by Renato Costa
 */

/*
LINK : used in the link viewer
no_link : an error message which indicates that there is no link
bad_link : an error message which indicates that the link reference no document
*/

#define HI18N_LINK_FR (h_I18nLink) {    \
  .no_link="pas de lien",                       \
  .bad_link="mauvais lien"                     \
}

#define HI18N_LINK_EN (h_I18nLink) {    \
  .no_link="no link",                       \
  .bad_link="bad link"                     \
}

#define HI18N_LINK_PT (h_I18nLink) {    \
  .no_link="sem ligao",                       \
  .bad_link="ligao invlida"                     \
}

/*
BOOKMARK : used in the bookmark viewer
bookmark : the title of the viewer
no_bookmark : an error message which indicates that there is no bookmark
*/
#define HI18N_BOOKMARK_FR (h_I18nBookmark) { \
  .bookmarks="Marques-pages",                      \
  .no_bookmark="pas de Marque page"            \
}

#define HI18N_BOOKMARK_EN (h_I18nBookmark) { \
  .bookmarks="Bookmarks",                      \
  .no_bookmark="no bookmark"            \
}

#define HI18N_BOOKMARK_PT (h_I18nBookmark) { \
  .bookmarks="Marcas de texto",                      \
  .no_bookmark="sem marcas de texto"            \
}

/*
LOG : used in the log view
log : the title
.log_err : the table of possible error names
 - it's a syntax error for the margin
 - it's a syntax error for the line format
 - the specified font is not found
 - there is the forbidden character 10
 - there is the forbidden character 0
 - it's a syntax error in the special character
 - it's a syntax error in the character format
 - it's a syntax error in the link
*/
#define HI18N_LOG_FR (h_I18nLog) {             \
  .log="Rapport d'erreur",                      \
	.log_err= {                                   \
		"Erreur de syntaxe: mauvaise marge",       \
    "Erreur de syntaxe: mauvais format de linge",			\
    "Police non trouve",												\
		"Caractre 10 interdit",  					        \
		"Caractre 0 interdit",             				\
		"Erreur dans le caractre spcial",            \
		"Erreur de syntaxe: mauvais format caractre",  \
		"Erreur de syntaxe: mauvais lien"					\
	}                                             \
}

#define HI18N_LOG_EN (h_I18nLog) {             \
  .log="Logs",                      \
  .log_err= {                                   \
    "Syntax error : wrong margin",       \
    "Syntax error : wrong line format",     \
    "Font not found",                       \
    "The character 10 is forbidden",                    \
    "The character 0 is forbidden",                     \
    "Syntax error: wrong special character",            \
    "Syntax error: wrong character format",  \
    "Syntax error : wrong link"         \
  }                                             \
}

#define HI18N_LOG_PT (h_I18nLog) {             \
  .log="Relatrio de erro",                      \
  .log_err= {                                   \
    "Erro de sintaxe : margem invlida",       \
    "Erro de sintaxe : formato de linha invlido",     \
    "Fonte no encontrada",                       \
    "O caracter 10  proibido",                    \
    "O caracter 0  proibido",                     \
    "Erro de sintaxe : caracter especial invlido",            \
    "Erro de sintaxe : formato de caracter invlido",  \
    "Erro de sintaxe : erro de ligao"         \
  }                                             \
}

