


#include "mkhibliba.h"


// the owl for the framed message
unsigned short h_owl[] = { 
  0b0111110101111111,
  0b0101100000110111,
  0b1000101010100010,
  0b1000100100100010,
  0b1000100000100010,
  0b0100110001100110,
  0b0111111111111111,
  0b0000011011000000
};


/**
 * Draw a message in a box with a title centered in the LCD screen
 * 
 * @param font the font to use
 * @param title the title of the message
 * @param tab_message a table of string which contains the different lines of the message
 * @param nb the number of message
 */
void h_drawMessage(h_Font * font, const char * title, const unsigned char * (tab_message[]), short nb) {

  short x;
  short y;
  short width;
  short x2;
  short y2;
  short len_str;
  short j;
  short len_title = hl_strWidth(font, title, FALSE, FALSE);
  
  width = len_title + 20;
  
//get the size of the longest line
  for (j = 0; j < nb; j++) {
    len_str = hl_strWidth(font, tab_message[j], FALSE, FALSE);
    if (len_str > width) {
      width = len_str;
    }
  }

  x = (LCD_WIDTH - width - 8) / 2;
  x2 = x + width + 8;
  y = (LCD_HEIGHT - 15 - 6 * nb) / 2;
  y2 = y + 15 + 6 * nb;
  
  hl_fillFrame(x, y, x + len_title + 18 + 1 + 1, y + 8, HGRAPHMODE_WHITE, LCD_SCREEN);
  hl_fillFrame(x, y + 8, x2, y2, HGRAPHMODE_WHITE, LCD_SCREEN);
  
  h_drawFrame(x, y, x + len_title + 20 + 3, y + 8, LCD_SCREEN);
  h_drawFrame(x, y + 9, x2, y2, LCD_SCREEN);
  Sprite16(x + 1, y + 1, 8, h_owl, LCD_MEM, SPRT_XOR);

  hl_drawStr(font, x + 19, y + 2, title, FALSE, FALSE, LCD_SCREEN);
    
  y += 7;
  for (j = 0; j < nb; j++) {
    hl_drawStr(font, x + 4, y += 6, tab_message[j], FALSE, FALSE, LCD_SCREEN);
  }
}


