
#include "mkhibliba.h"

/**
 * Give the type of a file
 *
 * @param data the datas of the file to scan
 *
 * @return the TAG of the file + the type of compression
 */
unsigned short h_getFileType(unsigned char * data) {
  unsigned short size = *(unsigned short *)data;
  short type = 0;
  type = data[size + 1];
  if (type == OTH_TAG) {
    if (strcmp(&(data[size - 4]), "HTXT") == 0) {
      return CUSTOM_TAG + HTXT_TAG;
    }
    if (strcmp(&(data[size - 4]), "LZFO") == 0) {
      return LZFO_TAG + h_getLzfoTag(data);
    }
    if (strcmp(&(data[size - 3]), "ZIP") == 0) {
      return ZIP_TAG + h_getZippedTag(data);
    }
  }
  return type;
}

