
#include "mktest.h"

void test_link_nav(const unsigned char * title, h_Link * tablink, short nb_links,
      h_ScrLine * hscrlines, short line_top, short line_bot,
      short buffer_x, short buffer_y, short buffer_width, short buffer_height,
      short noline, short no_link_prev, short no_link_next,
      short searchlink, short prevlink, short nextlink, short firstlink, short lastlink) {

  h_File hfile;
  hfile.hlinks = tablink;
  hfile.nb_links = nb_links;
  hfile.hscrlines = hscrlines;
  hfile.line_top = line_top;
  hfile.line_bot = line_bot;
  hfile.buffer.pos.x = buffer_x;
  hfile.buffer.pos.y = buffer_y;
  hfile.screen.size.width = buffer_width;
  hfile.screen.size.height = buffer_height;
  
  begintest("link navigation", title);
  
  testvalue("firstofline", hl_firstLinkOfLine(noline, &hfile), searchlink);
  
  testvalue("prev", hl_getPrevLinkOfPage(no_link_prev, &hfile), prevlink);

  testvalue("next", hl_getNextLinkOfPage(no_link_next, &hfile), nextlink);
  
  testvalue("first", hl_getFirstLinkOfPage((&hfile)), firstlink);
  
  testvalue("last", hl_getLastLinkOfPage((&hfile)), lastlink);
  
//  printf("top=%d, first=%d",hfile.line_top,hl_firstLinkOfLine(hfile.line_top,&hfile));
//  printf("bot=%d, first=%d",hfile.line_bot,hl_firstLinkOfLine(hfile.line_bot+1,&hfile));  
  
  finishtest();  

}

void test_link_graph() {
//  BOOL hl_getTargetLink(unsigned char * name_var, short no_link, h_File * hfile) {

//  SCR_RECT hl_getLinkPosition(short no_link, h_File * hfile) {

// short hl_getLink(short x, short y, h_File * hfile) {

}

