// C Source File
// Created 10/11/2003; 23:11:05


#include "mktest.h"

void init(const unsigned char * text,unsigned short size_text,h_FrtLine * current_frtline,h_Format * current_frt,h_File * hfile, h_Study * hstudy) {
  *hstudy = (h_Study) { 
    .pos_txt=0,
    .size_objs=(size_text>>5)+20,
    .size_logs=1,
    .size_links=1,
    .size_bkmks=1,
    .size_bkmks_level=1,
    .size_text_bkmk=20,
    .nb_bkmks_level=0
  };
  
  *current_frt =  (h_Format) { 
    .num_font=2,
    .underline=0,
    .dotted=0,
    .vector=0,
    .conjug=0,
    .strike=0,
    .exponent=0,
    .suffix=0,
    .inversed=0,
    .wordwarp=0,
    .link=0,
    .italic=0,
    .bold=0
  };
  
  *current_frtline = (h_FrtLine) {
    .margin=0,
    .align=HALIGN_LEFT
  };
  
  *hfile = (h_File) {
    .text=text,
    .size_text=size_text,
    .hh = (h_Header) {
      .pos_title=NOK,
      .pos_author=NOK,
      .pos_date=NOK,
      .pos_comment=NOK,
      .pos_name_font = { 
        NOK, 0, 0, 0, NOK, NOK, NOK, NOK, NOK, NOK 
      }
    },
    .nb_targetlinks=0,
    .nb_tioslines=0,
    .h_buffer=H_NULL,
    .h_scrlines=H_NULL,
    .h_links=H_NULL,
    .buffer.pos.y=0,
    .buffer.pos.x=0
  };
  
  hfile->nb_logs=0;
  hfile->h_logs=HeapAlloc(hstudy->size_logs*sizeof(h_Log));

  hfile->nb_bkmks=0;
  hfile->h_bkmks=HeapAlloc(hstudy->size_bkmks*sizeof(h_Bookmark));

  hstudy->nb_bkmks_level=0;
  hfile->h_bkmks_level=HeapAlloc(hstudy->size_bkmks_level*sizeof(h_MenuLevel));

  hfile->nb_objs=0;
  hfile->h_objs=HeapAlloc(hstudy->size_objs*sizeof(h_Object));
  
  hl_lockhFile(hfile);

}



/*===============================================================================================
== test the reading of the header
===============================================================================================*/
void test_parse_header(const unsigned char * text, const unsigned char * title,
  BOOL returned_value,
  short pos_title,
  short pos_author,
  short pos_comment,
  short pos_date,
  short pos_txt,
  short pos_font[10]) {

  h_Header hh_null = {
    .pos_title=NOK,
    .pos_author=NOK,
    .pos_date=NOK,
    .pos_comment=NOK,
    .pos_name_font = {
      NOK, 0, 0, 0, NOK, NOK, NOK, NOK, NOK, NOK
    }
  };
  h_File hfile;
  h_Study hstudy;
  BOOL bool;
  short j;
  unsigned char buffer[10];
  
  begintest("parse header",title);
    
  hfile.nb_logs=0;
  hstudy.size_logs=1;
  hfile.h_logs=HeapAlloc(sizeof(h_Log));
  hfile.nb_bkmks=0;
  hfile.h_bkmks=HeapAlloc(sizeof(h_Bookmark));
  hstudy.nb_bkmks_level=0;
  hfile.h_bkmks_level=HeapAlloc(sizeof(h_MenuLevel));
  hfile.nb_objs=0;
  hfile.h_objs=HeapAlloc(sizeof(h_Object));
  
  hstudy.pos_txt=0;
  hfile.hh=hh_null;
  hfile.text=text;
  bool=hparseHeader(&hfile,&hstudy);
  testvalue("returned value",bool,returned_value);
  testvalue("pos_title",hfile.hh.pos_title,pos_title);
  testvalue("pos_author",hfile.hh.pos_author,pos_author);
  testvalue("pos_comment",hfile.hh.pos_comment,pos_comment);
  testvalue("pos_date",hfile.hh.pos_date,pos_date);
  testvalue("pos_txt",hstudy.pos_txt,pos_txt);
  for (j=0;j<9;j++) {
    sprintf(buffer,"font %d",j);
    testvalue(buffer,hfile.hh.pos_name_font[j],pos_font[j]);
  }
  HeapFree(hfile.h_logs);
  HeapFree(hfile.h_bkmks);
  HeapFree(hfile.h_bkmks_level);
  HeapFree(hfile.h_objs);
  
  finishtest();

}


/*===============================================================================================
== test
===============================================================================================*/
void test_parse_bkmk(const unsigned char * text, const unsigned char * title,
  BOOL returned_value,
  short study_pos_txt,
  short nb_bookmks,
  short bkmk_pos_txt,
  short level) {

  h_Study hstudy;
  h_File hfile;
  BOOL bool;
  h_Format current_frt;
  h_FrtLine current_frtline;
    
  begintest("parse bookmark",title);
  
  init(text,strlen(text),&current_frtline,&current_frt,&hfile,&hstudy);
  hstudy.pos_txt=1;
  bool=hparseBookmark(&hfile,&hstudy);
  testvalue("returned value",bool,returned_value);
  testvalue("pos_txt study",hstudy.pos_txt,study_pos_txt);
  testvalue("nb_bkmks",hfile.nb_bkmks,nb_bookmks);
  testvalue("pos_txt bkmk",hfile.hbkmks->pos_txt,bkmk_pos_txt);
  testvalue("level",hfile.hbkmks_level->level,level);
  hl_freehFile(&hfile);
      
  finishtest();

}

/*===============================================================================================
== test
===============================================================================================*/
void test_parse_frtline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short margin,
  short align) {

  h_Study hstudy;
  h_File hfile;
  h_FrtLine current_frtline;
  h_Format current_frt;
  BOOL bool;
      
  begintest("parse line format",title);
  
  init(text,strlen(text),&current_frtline,&current_frt,&hfile,&hstudy);
  bool=hparseFrtLine(&current_frtline,&hfile,&hstudy);
  testvalue("returned value",bool,returned_value);
  testvalue("pos_txt",hstudy.pos_txt,pos_txt);
  testvalue("margin",current_frtline.margin,margin);
  testvalue("align",current_frtline.align,align);
  hl_freehFile(&hfile);
    
  finishtest();

}




/*===============================================================================================
== test
===============================================================================================*/
void test_parse_objline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short type,
  BOOL is_obj2) {

  h_Study hstudy;
  h_File hfile;
  h_FrtLine current_frtline;
  h_Format current_frt;
  BOOL bool;
  BOOL is_obj=FALSE;
  
  begintest("parse line object",title);
  
  init(text,strlen(text),&current_frtline,&current_frt,&hfile,&hstudy);
  bool=hparseObjectLine(&is_obj,&hfile,&hstudy);
  testvalue("returned value",bool,returned_value);
  testvalue("pos_txt",hstudy.pos_txt,pos_txt);
  testvalue("type",hfile.hobjs->type,type);
  testvalue("is_obj",is_obj,is_obj2);
  hl_freehFile(&hfile);
  
  finishtest();

}





/*===============================================================================================
== test
===============================================================================================*/
void test_parse_tiosline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short nb_objs,
  short tabtest[][14]) {

  h_Study hstudy;
  h_File hfile;
  h_Format frt;
  h_FrtLine current_frtline;
  h_Format current_frt= {
    .num_font=2,
    .underline=0,
    .dotted=0,
    .vector=0,
    .conjug=0,
    .strike=0,
    .exponent=0,
    .suffix=0,
    .bold=0,
    .italic=0,
    .inversed=0,
    .link=0,
    .wordwarp=0
  };
  BOOL bool;
  short i;
  
  unsigned char buffer[20];
  
  begintest("parse line",title);
  
  init(text,strlen(text),&current_frtline,&frt,&hfile,&hstudy);
  bool=hparseLine(&current_frt,&hfile,&hstudy);
  testvalue("returned value",bool,returned_value);
  testvalue("pos_txt",hstudy.pos_txt,pos_txt);
  testvalue("nb obj",hfile.nb_objs,nb_objs);
  for (i=0;i<hfile.nb_objs;i++) {
    frt=hfile.hobjs[i].datas.frt;
    sprintf(buffer,"type %d",i);
    testvalue(buffer,hfile.hobjs[i].type,tabtest[i][0]);
    sprintf(buffer,"pos_txt %d",i);
    testvalue(buffer,hfile.hobjs[i].pos_txt,tabtest[i][1]);
    if (tabtest[i][0]==HOBJECT_TEXT) {
      sprintf(buffer,"num_font %d",i);
      testvalue(buffer,frt.num_font,tabtest[i][2]);
      sprintf(buffer,"underline %d",i);
      testvalue(buffer,(frt.underline!=0),tabtest[i][3]);
      sprintf(buffer,"dotted %d",i);
      testvalue(buffer,(frt.dotted!=0),tabtest[i][4]);
      sprintf(buffer,"vector %d",i);
      testvalue(buffer,(frt.vector!=0),tabtest[i][5]);
      sprintf(buffer,"conjug %d",i);
      testvalue(buffer,(frt.conjug!=0),tabtest[i][6]);
      sprintf(buffer,"strike %d",i);
      testvalue(buffer,(frt.strike!=0),tabtest[i][7]);
      sprintf(buffer,"exponent %d",i);
      testvalue(buffer,(frt.exponent!=0),tabtest[i][8]);
      sprintf(buffer,"suffix %d",i);
      testvalue(buffer,(frt.suffix!=0),tabtest[i][9]);
      sprintf(buffer,"link %d",i);
      testvalue(buffer,(frt.link!=0),tabtest[i][10]);
      sprintf(buffer,"italic %d",i);
      testvalue(buffer,(frt.italic!=0),tabtest[i][11]);
      sprintf(buffer,"bold %d",i);
      testvalue(buffer,(frt.bold!=0),tabtest[i][12]);
      sprintf(buffer,"inversed %d",i);
      testvalue(buffer,(frt.inversed!=0),tabtest[i][13]);
    }
  }
  hl_freehFile(&hfile);

  finishtest();

}



/*===============================================================================================
== test
===============================================================================================*/
void test_parse_all(const unsigned char * text, const unsigned char * title,
  TestParse * testparse) {
  
  h_File hfile;
  h_Format frt;
  h_FrtLine frtline;
  short i;
  BOOL err;
  unsigned char buffer[20];

  begintest("parse all",title);
  
  err=hl_parse(&hfile,text,strlen(text));
  hl_lockhFile(&hfile);
  testvalue("returned value",err,testparse->err);
  testvalue("nb obj",hfile.nb_objs,testparse->nb_objs);
  for (i=0;i<hfile.nb_objs;i++) {
    frt=hfile.hobjs[i].datas.frt;
    frtline=hfile.hobjs[i].datas.frtline;
    sprintf(buffer,"type %d",i);
    testvalue(buffer,hfile.hobjs[i].type,(*(testparse->datas))[i][0]);
    sprintf(buffer,"pos_txt %d",i);
    testvalue(buffer,hfile.hobjs[i].pos_txt,(*(testparse->datas))[i][1]);
    if ((*(testparse->datas))[i][0]==HOBJECT_TEXT) {
      sprintf(buffer,"num_font %d",i);
      testvalue(buffer,frt.num_font,(*(testparse->datas))[i][2]);
      sprintf(buffer,"underline %d",i);
      testvalue(buffer,(frt.underline!=0),(*(testparse->datas))[i][3]);
      sprintf(buffer,"dotted %d",i);
      testvalue(buffer,(frt.dotted!=0),(*(testparse->datas))[i][4]);
      sprintf(buffer,"vector %d",i);
      testvalue(buffer,(frt.vector!=0),(*(testparse->datas))[i][5]);
      sprintf(buffer,"conjug %d",i);
      testvalue(buffer,(frt.conjug!=0),(*(testparse->datas))[i][6]);
      sprintf(buffer,"strike %d",i);
      testvalue(buffer,(frt.strike!=0),(*(testparse->datas))[i][7]);
      sprintf(buffer,"exponent %d",i);
      testvalue(buffer,(frt.exponent!=0),(*(testparse->datas))[i][8]);
      sprintf(buffer,"suffix %d",i);
      testvalue(buffer,(frt.suffix!=0),(*(testparse->datas))[i][9]);
      sprintf(buffer,"link %d",i);
      testvalue(buffer,(frt.link!=0),(*(testparse->datas))[i][10]);
      sprintf(buffer,"italic %d",i);
      testvalue(buffer,(frt.italic!=0),(*(testparse->datas))[i][11]);
      sprintf(buffer,"bold %d",i);
      testvalue(buffer,(frt.bold!=0),(*(testparse->datas))[i][12]);
      sprintf(buffer,"inversed %d",i);
      testvalue(buffer,(frt.inversed!=0),(*(testparse->datas))[i][13]);
    } else if ((*(testparse->datas))[i][0]==HOBJECT_TIOS_LINE) {
      sprintf(buffer,"margin %d",i);
      testvalue(buffer,frtline.margin,(*(testparse->datas))[i][14]);
      sprintf(buffer,"align %d",i);
      testvalue(buffer,frtline.align,(*(testparse->datas))[i][15]);
    }
  }
  teststring("title",h_getTitle((&hfile)),testparse->htitle);
  teststring("author",h_getAuthor((&hfile)),testparse->hauthor);
  teststring("date",h_getDate((&hfile)),testparse->hdate);
  teststring("comment",h_getComment((&hfile)),testparse->hcomment);
  
  testvalue("nb bkmk",hfile.nb_bkmks,testparse->nb_bkmks);
  for (i=0;i<hfile.nb_bkmks;i++) {
    sprintf(buffer,"bkmk pos_txt %d",i);
    testvalue(buffer,hfile.hbkmks[i].pos_txt,(*(testparse->bkmks))[i][0]);
    sprintf(buffer,"bkmk level %d",i);
    testvalue(buffer,hfile.hbkmks_level[i].level,(*(testparse->bkmks))[i][1]);
  }
      
  hl_freehFile(&hfile);
  
  finishtest();
    
}

