
#include "mkhibliba.h"

/**
 * Transform a table of font to make font bigger. The font names
 * and font datas will be translated :
 * "tios1" will point on "tios2" datas
 * "tios2" will point on "tios3" datas
 * "tios3" will continue to point on "tios3" datas
 * 
 * @param fonttab the normal font table
 * @param nb_font the number of font in the table
 *
 * @return a new font table with the translated font
 */
h_Font * h_setBigFont(h_Font * fonttab, short nb_font) {
  short nums[3];
  short j;
  unsigned char name[] = "tios0";
  short n;
  
  h_Font * bigfonttab = malloc(nb_font * sizeof(h_Font));
  
  if (bigfonttab == NULL) {
    return NULL;
  }
  
  memcpy(bigfonttab, fonttab, nb_font * sizeof(h_Font));
  
  for (j = 0; j < 3; j++) {
    name[4]++;
    n = nb_font;
    while (--n >= 0) {
      if (strcmp(name, fonttab[n].filename) == 0) { // found !
        nums[j] = n;
        break;
      }
    }
  }
  
  bigfonttab[nums[1]] = fonttab[nums[2]];
  bigfonttab[nums[1]].filename[4] = '2';
  bigfonttab[nums[0]] = fonttab[nums[1]];
  bigfonttab[nums[0]].filename[4] = '1';

  return bigfonttab;
}
