
#ifndef __hiblib__
#define __hiblib__

asm("hiblib: .xdef hiblib");

/**************** Main engine ********************/

#define h_isPic(hfile) hfile->isPic

#define hl_parse				hiblib__0000
BOOL hl_parse(h_File * hfile, const unsigned char * text, unsigned short size_text);

#define hl_layout				hiblib__0001
BOOL hl_layout(h_File * hfile, short width, BOOL allowBigObject, h_Font * fonttab, short nb_font, FctIsComp iscomp, FctUnComp uncomp);

#define hl_freehFile				hiblib__0002
void hl_freehFile(h_File * hfile);

#define hl_lockhFile				hiblib__0003
void hl_lockhFile(h_File * hfile);

#define hl_unlockhFile			hiblib__0004
void hl_unlockhFile(h_File * hfile);

#define hl_setScreen			hiblib__0005
void hl_setScreen(h_File * hfile, void * screen, short x, short y, short width, short height);

#define hl_screenCopy			hiblib__0006
void hl_screenCopy(h_Screen dst, h_Screen src);

#define hl_drawPage			hiblib__0007
void hl_drawPage(short no_line, h_File * hfile);

#define hl_refreshScreen(hfile)   {hl_fillFrame(hfile->screen.pos.x,hfile->screen.pos.y,hfile->screen.pos.x+hfile->screen.size.width-1,hfile->screen.pos.y+hfile->screen.size.height-1,HGRAPHMODE_WHITE,hfile->screen.mem);hl_screenCopy(hfile->screen,hfile->buffer);}

#define hl_changeScreen(hfile,screen,x,y,width,height) {hl_setScreen(hfile,screen,x,y,width,height);hl_updateBuffers(hfile);hl_refreshScreen(hfile);}

#define hl_initScreen(hfile,screen,x,y,width,height) {hl_setScreen(hfile,screen,x,y,width,height);hl_drawPage(0, hfile);}

#define hl_redraw(hfile)  {hl_drawPage(-1,hfile);}

/**************** Scrolling capabilities ********************/

#define hl_updateBuffers  hiblib__0010
void hl_updateBuffers(h_File * hfile);

#define hl_goPixelDown  hiblib__0011
void hl_goPixelDown(h_File * hfile);

#define hl_goPixelUp  hiblib__0012
void hl_goPixelUp(h_File * hfile);

#define hl_goPixelLeft  hiblib__0013
void hl_goPixelLeft(h_File * hfile);

#define hl_goPixelRight  hiblib__0014
void hl_goPixelRight(h_File * hfile);

#define hl_goLastPage(hfile) hl_goTo(hfile->nb_scrlines,-1,hfile)
#define hl_goFirstPage(hfile) hl_goTo(0,-1,hfile)
#define hl_goLeft(hfile)
#define hl_goRight(hfile)

#define hl_goPageDown(hfile,common_band) {hfile->buffer.pos.y += hfile->screen.size.height - common_band;hl_updateBuffers(hfile);hl_refreshScreen(hfile);}
#define hl_goPageUp(hfile,common_band)  {hfile->buffer.pos.y += common_band - hfile->screen.size.height;hl_updateBuffers(hfile);hl_refreshScreen(hfile);}
#define hl_goPageLeft(hfile,common_band)
#define hl_goPageRight(hfile,common_band)

#define hl_canGoDown(hfile) (hfile->line_bot<hfile->nb_scrlines-1 || hfile->buffer.pos.y+hfile->screen.size.height<hfile->drawn_height)
#define hl_canGoUp(hfile) (hfile->line_top!=0 || hfile->buffer.pos.y>0)
#define hl_canGoLeft(hfile) (hfile->buffer.pos.x>0)
#define hl_canGoRight(hfile) (hfile->buffer.pos.x+hfile->screen.size.width<hfile->buffer.size.width)

/**************** Font ********************/
#define hl_drawChar		hiblib__0020
short hl_drawChar(h_Font * font, short x, short y, unsigned char caract, BOOL italic, BOOL bold, h_ScreenMem screen);

#define hl_drawStr			hiblib__0021
short hl_drawStr(h_Font * font, short x, short y, const unsigned char * str, BOOL italic, BOOL bold, h_ScreenMem screen);

#define hl_charWidth		hiblib__0022
short hl_charWidth(h_Font * font, unsigned char caract, BOOL italic, BOOL bold);

#define hl_italicWidth(font) ((font->upperline+font->underline)/3)

#define hl_strWidth		hiblib__0023
short hl_strWidth(h_Font * font, const unsigned char * str, BOOL italic, BOOL bold);

#define hl_loadTiosFont		hiblib__0024
void hl_loadTiosFont(h_Font * font1,h_Font * font2,h_Font * font3);

#define hl_loadAllFont		hiblib__0025
short hl_loadAllFont(h_Font * * fonttab);

#define hl_unloadAllFont		hiblib__0026
void hl_unloadAllFont(h_Font * fonttab, short nb_font);

#define hl_findFont		hiblib__0027
h_Font * hl_findFont(const unsigned char * filename_font, h_Font * fonttab, short nb_font);

/**************** Menu ********************/
#define hl_drawMenu		hiblib__0030
void hl_drawMenu(h_Menu * hmenu, h_ScreenMem screen);

#define hl_goMenuBottom		hiblib__0031
void hl_goMenuBottom(h_Menu * hmenu);

#define hl_goMenuPageDown		hiblib__0032
void hl_goMenuPageDown(h_Menu * hmenu);

#define hl_goMenuDown		hiblib__0033
void hl_goMenuDown(h_Menu * hmenu);

#define hl_goMenuTop		hiblib__0034
void hl_goMenuTop(h_Menu * hmenu);

#define hl_goMenuPageUp		hiblib__0035
void hl_goMenuPageUp(h_Menu * hmenu);

#define hl_goMenuUp		hiblib__0036
void hl_goMenuUp(h_Menu * hmenu);

#define hl_goSubMenu		hiblib__0037
void hl_goSubMenu(h_Menu * hmenu);

#define hl_goUpperMenu		hiblib__0038
void hl_goUpperMenu(h_Menu * hmenu);

#define hl_setMenuMove(hmenu)   (hmenu->move=1)
#define hl_resetMenuMove(hmenu)   (hmenu->move=0)
#define hl_changeMenuMove(hmenu)   (hmenu->move=1-hmenu->move)

/**************** Utils ********************/

#define hl_addHANDLE		hiblib__0043
short hl_addHANDLE(HANDLE * h, unsigned short * nb, unsigned short * size, unsigned short size_item);

#define hl_drawLineVert		hiblib__0045
void hl_drawLineVert(short x, short y1, short y2, short mode, h_ScreenMem screen);

#define hl_fillFrame		hiblib__0046
void hl_fillFrame(short x1, short y1, short x2, short y2, short mode, h_ScreenMem screen);

#define hl_drawLineHoriz(x1,x2,y,mode,screen) hl_fillFrame(x1,y,x2,y,mode,screen)
#define hl_drawPixel(x,y,mode,screen) hl_drawLineVert(x,y,y,mode,screen);

#define hl_clrScreen(screen)   memset(screen.mem.ptr,0,screen.size.height*screen.mem.byte_width)

/**************** Bookmark ********************/

#define hl_drawBookmark		hiblib__0050
void hl_drawBookmark(h_File * hfile, short no_bkmk, short x, short y, short lcdwidth, h_ScreenMem screen, h_Font * font);

#define hl_goTo		hiblib__0051
void hl_goTo(short num_line, short bookmark, h_File * hfile);

/**************** Links ********************/

#define hl_firstLinkOfLine		hiblib__0060
short hl_firstLinkOfLine(short no_line, h_File * hfile);

#define hl_getPrevLinkOfPage		hiblib__0061
short hl_getPrevLinkOfPage(short no_link, h_File * hfile);

#define hl_getNextLinkOfPage		hiblib__0062
short hl_getNextLinkOfPage(short no_link, h_File * hfile);

#define hl_getFirstLinkOfPage(hfile) hl_getNextLinkOfPage(hl_firstLinkOfLine(hfile->line_top,hfile)-1,hfile)
#define hl_getLastLinkOfPage(hfile) hl_firstLinkOfLine(hfile->line_bot+1,hfile)

#define hl_getTargetLink		hiblib__0063
BOOL hl_getTargetLink(unsigned char * name_var, short no_link, h_File * hfile);

#define hl_getLinkPosition		hiblib__0064
h_LinkPos hl_getLinkPosition(short no_link, h_File * hfile);

#define hl_getLink		hiblib__0065
short hl_getLink(short x, short y, h_File * hfile);


#define h_getAuthor(hfile)   (hfile->hh.pos_author==NOK ? NULL : hfile->text+hfile->hh.pos_author)
#define h_getComment(hfile)  (hfile->hh.pos_comment==NOK ? NULL : hfile->text+hfile->hh.pos_comment)
#define h_getDate(hfile)     (hfile->hh.pos_date==NOK ? NULL : hfile->text+hfile->hh.pos_date)
#define h_getTitle(hfile)    (hfile->hh.pos_title==NOK ? NULL : hfile->text+hfile->hh.pos_title)

#endif


