
#include "mkhiblib.h"

/**
 * Function used by the hMenu to draw the title of the bookmark in the bookmark menu
 * 
 * @see h_FctDrawMenu in hibtypes.h
 */
void hl_drawBookmark(h_File * hfile, short no_bkmk, short x, short y, short lcdwidth, h_ScreenMem screen, h_Font * font) {
  short pos_txt = hfile->hbkmks[no_bkmk].pos_txt;
  short caract;
  BOOL title = TRUE;
  
  if (hfile->text[pos_txt] == 12)
  {
  	//there's no '&T' tag
    pos_txt++;
    title = FALSE;
  }
  else if (hfile->text[pos_txt] == '&' && hfile->text[pos_txt+1] == 'T')
  {
	//no bookmark short title defined
	pos_txt += 2;
	title = FALSE;
  }
  
  if (title) {
    caract = hfile->text[pos_txt++];
  } else {
    caract = hreadCaract(hfile->text, &pos_txt);
  }

  do {
    x += hl_drawChar(font, x, y, caract, FALSE, FALSE, screen) + 1;
    if (title) {
      caract = hfile->text[pos_txt++];
    } else {
      caract = hreadCaract(hfile->text, &pos_txt);
    }
  } while (caract != '\0' && caract != 13 && !(title && caract == '&' && hfile->text[pos_txt] == 'T') && x < lcdwidth - 15); //util the end of the screen or the line
  //TODO is 15 a good constant ?
  if (x >= lcdwidth - 15)
    hl_drawChar(font, x, y, '\240', FALSE, FALSE, screen);

}
