
#include "mkhiblib.h"

/**
 * Return the number of the first link of the line
 * If there is no link on the line.... TODO I don't really know what it does
 * 
 * @param no_line the number of the line
 * @param hfile the file to study
 *
 * @return the number of the first link of the line
 */
short hl_firstLinkOfLine(short no_line, h_File * hfile) {
  short no_link = hfile->nb_links / 2;
  short step = (no_link + 1) / 2;
  while (hfile->hlinks[no_link].no_scrline != no_line) {
    if (hfile->hlinks[no_link].no_scrline > no_line) {
      no_link -= step;
    } else {
      no_link += step;
    }
    if (step <= 1) {
      break;
    }
    step = (step + 1) / 2;
  }
  
  while (hfile->hlinks[no_link - 1].no_scrline == no_line) {
    no_link--;
  }
  
  return no_link;
}

/**
 * Return the previous link which is in the screen
 * 
 * @param no_link the number of the link to start
 * @param hfile the file to study
 *
 * @return the previous link which is in the screen, NOK (-1) if not in the screen
 */
short hl_getPrevLinkOfPage(short no_link, h_File * hfile) {
  h_LinkPos pos;
  
  do {
    no_link--;
    if (no_link < 0)
      return NOK;
    pos = hl_getLinkPosition(no_link, hfile);
  } while (!pos.inscreen && hfile->hlinks[no_link].no_scrline >= hfile->line_top);
  
  if (!pos.inscreen)
    return NOK;
  
  return no_link;
}

/**
 * Return the next link which is in the screen
 * 
 * @param no_link the number of the link to start
 * @param hfile the file to study
 *
 * @return the next link which is in the screen, NOK (-1) if not in the screen
 */
short hl_getNextLinkOfPage(short no_link, h_File * hfile) {
  h_LinkPos pos;
  
  do {
    no_link++;
    if (no_link >= hfile->nb_links)
      return NOK;
    pos = hl_getLinkPosition(no_link, hfile);
  } while (!pos.inscreen && hfile->hlinks[no_link].no_scrline <= hfile->line_bot);
  
  if (!pos.inscreen)
    return NOK;
  
  return no_link;
}

/**
 * Get the target of the link
 * 
 * @param name_var the target name of the link (the buffer have to be at least 20 bytes long)
 * @param no_link the number of the link
 * @param hfile the file to study
 *
 * @return FALSE if the target is more that 20 characters
 */
BOOL hl_getTargetLink(unsigned char * name_var, short no_link, h_File * hfile) {
  
  unsigned short pos_txt = hfile->hobjs[hfile->hlinks[no_link].no_obj].pos_txt + 2;
  short j = 0;
  
  while (hfile->text[pos_txt] != '#' && hfile->text[pos_txt] != 13 && hfile->text[pos_txt] != '\0' && j < 20) {
    name_var[j] = hfile->text[pos_txt];
    j++;
    pos_txt++;
  }
  if (j==20) {
    return FALSE;
  }
  name_var[j] = '\0';
  return TRUE;
}

/**
 * Return the position of the link
 * 
 * @param no_link the number of the link
 * @param hfile the file to study
 *
 * @return the position of the link
 */
h_LinkPos hl_getLinkPosition(short no_link, h_File * hfile) {
  h_LinkPos pos = {
    .inscreen = 1,
    .clip_x1 = 0,
    .clip_x2 = 0,
    .clip_y1 = 0,
    .clip_y2 = 0,
    .x1 = 0,
    .x2 = 0,
    .y1 = 0,
    .y2 = 0
  };
  
  if (hfile->hlinks[no_link].no_scrline < hfile->line_top ||
      hfile->hlinks[no_link].no_scrline > hfile->line_bot) {
    pos.inscreen = 0;
    return pos;
  }
  
  short y = 0;
  short no_line = hfile->line_top;
  while (no_line < hfile->hlinks[no_link].no_scrline) {
    y += hfile->hscrlines[no_line].height;
    no_line++;
  }
  y += hfile->hscrlines[no_line].exp_max;
  
  pos.y1 = y - hfile->hlinks[no_link].h_exp - hfile->buffer.pos.y - 1;
  pos.y2 = y + hfile->hlinks[no_link].h_suffix - hfile->buffer.pos.y;
  pos.x1 = hfile->hlinks[no_link].x1 - hfile->buffer.pos.x - 1;
  pos.x2 = hfile->hlinks[no_link].x2 - hfile->buffer.pos.x;

  if (pos.x2 < 0 || pos.x1 > hfile->screen.size.width ||
      pos.y2 < 0 || pos.y1 > hfile->screen.size.height) {
    pos.inscreen = 0;
    return pos;
  }
  
  if (pos.x1 < 0) {
    pos.x1 = 0;
    pos.clip_x1 = 1;
  }
  
  if (pos.x2 > hfile->screen.size.width) {
    pos.x2 = hfile->screen.size.width;
    pos.clip_x2 = 1;
  }
  
  if (pos.y1 < 0) {
    pos.y1 = 0;
    pos.clip_y1 = 1;
  }
  
  if (pos.y2 > hfile->screen.size.height) {
    pos.y2 = hfile->screen.size.height;
    pos.clip_y2 = 1;
  }
  
  return pos;
}

/**
 * Get the number of the link from a position in the screen
 * 
 * @param x the x position
 * @param y the y position
 * @param hfile the file to study
 *
 * @return the number of the found link, else NOK (-1)
 */
short hl_getLink(short x, short y, h_File * hfile) {

  x += hfile->buffer.pos.x;
  
  //get the scrline
  short no_line = hfile->line_top;
  while (y > 0) {
    y -= hfile->hscrlines[no_line].height;
    no_line++;
  }
  no_line--;
  y += hfile->hscrlines[no_line].height - hfile->hscrlines[no_line].exp_max;
  
  short no_link = hl_firstLinkOfLine(no_line,hfile);
    
  if (hfile->hlinks[no_link].no_scrline != no_line) {
    return NOK;
  }
    
  while (hfile->hlinks[no_link].no_scrline == no_line) {
    if (hfile->hlinks[no_link].x1 <= x
        && x <= hfile->hlinks[no_link].x2
        && hfile->hlinks[no_link].h_exp >= -y
        && hfile->hlinks[no_link].h_suffix >= y) {
      return no_link;
    }
    no_link++;
  }
  return NOK;

}

