// C Source File
// Created 07/02/2004; 23:33:07


#include "mkhibliba.h"


/**
 * Read a file at a dertimined bookmark or line
 *
 * @param num_line the number of line to begin with (-1 to disable it)
 * @param bookmark the bookmark to begin with (-1 to disable it); it should be used to return the
 * bookmark to begin with the new file to open
 * @param name_var a buffer which will be able to contain the name of the var to open
 * @param hfile the file to read
 * @param hcfg the config
 * @param hlangbookmark the i18n texts for the bookmark menu
 * @param hlanglink the i18n texts for the link view
 *
 * @return HKEY_NEWFILE if a new file have to be opend, else HKEY_NOKEY
 */
short h_readhFile(short num_line, short * bookmark, unsigned char * name_var, h_File * hfile, h_Config * hcfg, h_I18nBookmark * hi18nbookmark, h_I18nLink * hi18nlink) {

  short key = 0;
  short no_link;
  
  h_initSynchro(hcfg->speed_key);
move:
  hl_goTo(num_line, *bookmark, hfile);
  num_line = -1;
  *bookmark = -1;
draw:
  hl_refreshScreen(hfile);
  //wait for a key
  do {
    key=HKEY_NOKEY;
    h_waitSynchro();
    if (K_DOWN && hl_canGoDown(hfile)) {
      if (K_DIAM) {   //to the bottom
        h_startSynchro(hcfg->speed_key);
        hl_goLastPage(hfile);
      } else if (K_2ND) {  //by page
        h_startSynchro(hcfg->speed_key);
        hl_goPageDown(hfile, PAGE_SCROLL_COMMON_BAND);
      } else { //by pixel
        h_startSynchro(hcfg->speed_scroll);
        hl_goPixelDown(hfile);
      }
    } else if (K_UP && hl_canGoUp(hfile)) {  //scroll to the beginning
      if (K_DIAM) {  //to the top
        h_startSynchro(hcfg->speed_key);
        hl_goFirstPage(hfile);
      } else if (K_2ND) {  //by page
        h_startSynchro(hcfg->speed_key);
        hl_goPageUp(hfile, PAGE_SCROLL_COMMON_BAND);
      } else {  //by pixel
        h_startSynchro(hcfg->speed_scroll);
        hl_goPixelUp(hfile);
      }
    } else if (K_RIGHT && hl_canGoRight(hfile)) {
      if (K_DIAM) {  //to the top
        h_startSynchro(hcfg->speed_key);
        hl_goRight(hfile);
      } else if (K_2ND) {  //by page
        h_startSynchro(hcfg->speed_key);
        hl_goPageRight(hfile,PAGE_SCROLL_COMMON_BAND);
      } else {  //by pixel
        h_startSynchro(hcfg->speed_scroll);
        hl_goPixelRight(hfile);
      }
    } else if (K_LEFT && hl_canGoLeft(hfile)) {
      if (K_DIAM) { 
        h_startSynchro(hcfg->speed_key);
        hl_goLeft(hfile);
      } else if (K_2ND) {  //by page
        h_startSynchro(hcfg->speed_key);
        hl_goPageLeft(hfile, PAGE_SCROLL_COMMON_BAND);
      } else {  //by pixel
        h_startSynchro(hcfg->speed_scroll);
        hl_goPixelLeft(hfile);
      }
    } else if (K_CLEAR) {  // turn the calculator off
      off();
      h_startSynchro(hcfg->speed_key);
    } else if (K_APPS) {  //the bookmarks
      h_startSynchro(hcfg->speed_key);
      *bookmark = h_bookmarkMenu(hfile, hcfg, hi18nbookmark);
      if (*bookmark >= 0 && *bookmark < hfile->nb_bkmks) {
        goto move;
      }
      goto draw;
    } else if (K_ESC) {
      h_startSynchro(hcfg->speed_key);
      key=KEY_ESC;
    } else if (K_PLUS && K_DIAM) {  //to control the contrast
      h_startSynchro(hcfg->speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastDn();
    } else if (K_DIAM && K_L) {  // the links
      h_startSynchro(hcfg->speed_key);
      no_link = h_chooseLink(hfile, hcfg, hi18nlink);
      if (no_link == NOK) {
        goto draw;
      }
      //search the object of the link
      if (!hl_getTargetLink(name_var, no_link, hfile)) {
        goto draw;
      }
      key=HKEY_NEW_FILE;
    } else if (K_0) {  //the shortcuts
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 0) {
        *bookmark = 0;
        goto move;
      }
    } else if (K_1) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 1) {
        *bookmark = 1;
        goto move;
      }
    } else if (K_2) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 2) {
        *bookmark = 2;
        goto move;
      }
    } else if (K_3) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 3) {
        *bookmark = 3;
        goto move;
      }
    } else if (K_4) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 4) {
        *bookmark = 4;
        goto move;
      }
    } else if (K_5) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 5) {
        *bookmark = 5;
        goto move;
      }
    } else if (K_6) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 6) {
        *bookmark = 6;
        goto move;
      }
    } else if (K_7) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 7) {
        *bookmark = 7;
        goto move;
      }
    } else if (K_8) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 8) {
        *bookmark = 8;
        goto move;
      }
    } else if (K_9) {
      h_startSynchro(hcfg->speed_key);
      if (hfile->nb_bkmks > 9) {
        *bookmark = 9;
        goto move;
      }
    } else {
      h_saveEnergy();
    }
  } while (key == 0);

  h_waitSynchro();
  
  h_freeSynchro();
  
  return key;
}

