
#include "mkhibliba.h"

/**
 * Transform a table of font to make font more little. The font names
 * and font datas will be translated :
 * "tios3" will point on "tios2" datas
 * "tios2" will point on "tios1" datas
 * "tios1" will continue to point on "tios1" datas
 * 
 * @param fonttab the normal font table
 * @param nb_font the number of font in the table
 *
 * @return a new font table with the translated font
 */
h_Font * h_setLittleFont(h_Font * fonttab, short nb_font) {
  short nums[3];
  short j;
  unsigned char name[] = "tios0";
  short n;
  
  h_Font * littlefonttab = malloc(nb_font * sizeof(h_Font));
  
  if (littlefonttab == NULL) {
    return NULL;
  }
  
  memcpy(littlefonttab, fonttab, nb_font * sizeof(h_Font));

  for (j = 0; j < 3; j++) {
    name[4]++;
    n = nb_font;
    while (--n >= 0) {
      if (strcmp(name, fonttab[n].filename) == 0) { // found !
        nums[j] = n;
        break;
      }
    }
  }
    
  littlefonttab[nums[2]] = fonttab[nums[1]];
  littlefonttab[nums[2]].filename[4] = '3';
  littlefonttab[nums[1]] = fonttab[nums[0]];
  littlefonttab[nums[1]].filename[4] = '2';
  
  return littlefonttab;
}
