

#include "mktest.h"

  //returnparse,pos_txt,nb_obj,
  //{type,pos_txt,num_font,underline,dotted,vector,conjug,strike,exponent,suffix,link,italic,bold,inversed,margin,align}
  //title,author,date,comment,nb_bkmks,
  //{pos_txt,level}
  //returnlayout,nb_scrline,{pos_txt,space,width,exp_max,height}


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas01_simple = {
  .text=" some text",
  .title="01.simple",
  .parse = {
    .err=TRUE,
    .nb_objs=3,
    .datas=&(short [3][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=1,
    .datas=&(short [1][5]){
      {1,0,53,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};
  
/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas02_2lines = {
  .text=" word\r word",
  .title="02.2 lines",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,6,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,7,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,11,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,23,7,8},
      {7,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas03_font = {
  .text=" word#1word#2word\r word",
  .title="03.font",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,18,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,65,7,8},
      {19,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas04_underline = {
  .text=" wo#Urd\r word",
  .title="04.underline",
  .parse = {
    .err=TRUE,
    .nb_objs=6,
    .datas=&(short [6][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,3,2,1,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,8,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,9,2,1,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,13,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,23,7,10},
      {9,0,23,7,10}
    },  
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas05_dotted = {
  .text=" w#Nor#Nd w#Nord#Uword#Uwo#Nrd",
  .title="05.dotted",
  .parse = {
    .err=TRUE,
    .nb_objs=9,
    .datas=&(short [9][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,6,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,11,2,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,16,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,22,2,1,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,26,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,30,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=1,
    .datas=&(short [1][5]){
      {1,0,101,7,10}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas06_vectconj = {
  .text=" w#Jor#Jd w#Vor#Vd w#Jord#Vword#Vwo#Jrd",
  .title="06.vector & conj",
  .parse = {
    .err=TRUE,
    .nb_objs=11,
    .datas=&(short [11][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,6,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,11,2,0,0,1,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,15,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,20,2,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,25,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,31,2,0,0,1,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,35,2,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,39,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=1,
    .datas=&(short [1][5]){
      {1,0,131,10,11}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas07_expsuffix = {
  .text=" E#EE#EE#DE#DE\r #UE#EE#EE#DE#DE#U\r #JE#EE#EE#DE#DE#J\r #U#JE#EE#EE#DE#DE#J#U",
  .title="07.exp & suffix",
  .parse = {
    .err=TRUE,
    .nb_objs=25,
    .datas=&(short [25][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,8,2,0,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,15,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,16,2,1,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,19,2,1,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,22,2,1,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,25,2,1,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,28,2,1,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,34,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,35,2,0,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,38,2,0,0,0,1,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,41,2,0,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,44,2,0,0,0,1,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,47,2,0,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,53,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,54,2,1,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,59,2,1,0,0,1,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,62,2,1,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,65,2,1,0,0,1,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,68,2,1,0,0,1,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=4,
    .datas=&(short [4][5]){
      {1,0,29,11,16},
      {16,0,29,11,18},
      {35,0,29,13,18},
      {54,0,29,13,20}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas08_expsuffixfont = {
  .text=" E#EE#1E#3E#E#1E#EE#E#2\r E#DE#1E#3E#D#1E#DE#D#2",
  .title="08.exp & suffix & font",
  .parse = {
    .err=TRUE,
    .nb_objs=15,
    .datas=&(short [15][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,8,3,0,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,11,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,16,1,0,0,0,0,0,1,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,24,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,26,2,0,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,29,1,0,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,32,3,0,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_TEXT,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,40,1,0,0,0,0,0,0,1,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,31,12,13},
      {25,0,31,7,15}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas09_italic = {
  .text=" word#iword#iword\r #1word#iword#iword\r #2word#1#iword#2#iword\r #1word#2#iword#1#iword",
  .title="09.italic",
  .parse = {
    .err=TRUE,
    .nb_objs=17,
    .datas=&(short [17][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,5,2,0,0,0,0,0,0,0,0,1,0,0,0,0},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,18,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,19,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,25,1,0,0,0,0,0,0,0,0,1,0,0,0,0},
      {HOBJECT_TEXT,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,38,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,39,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,45,1,0,0,0,0,0,0,0,0,1,0,0,0,0},
      {HOBJECT_TEXT,53,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,62,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,63,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,69,2,0,0,0,0,0,0,0,0,1,0,0,0,0},
      {HOBJECT_TEXT,77,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=4,
    .datas=&(short [4][5]){
      {1,0,73,7,8},
      {19,0,54,5,6},
      {39,0,66,7,8},
      {63,0,61,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas10_bold = {
  .text=" word#Bword#Bword\r #1word#Bword#Bword\r #3word#Bword#Bword",
  .title="10.bold",
  .parse = {
    .err=TRUE,
    .nb_objs=13,
    .datas=&(short [13][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,5,2,0,0,0,0,0,0,0,0,0,1,0,0,0},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,18,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,19,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,25,1,0,0,0,0,0,0,0,0,0,1,0,0,0},
      {HOBJECT_TEXT,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,38,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,39,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,45,3,0,0,0,0,0,0,0,0,0,1,0,0,0},
      {HOBJECT_TEXT,51,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {1,0,75,7,8},
      {19,0,57,5,6},
      {39,0,99,9,10}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas11_inversed = {
  .text=" w#Ior#Id\r word",
  .title="11.inversed",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0},
      {HOBJECT_TEXT,6,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,10,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,23,7,8},
      {11,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas12_strike = {
  .text=" w#Sor#Sd\r word",
  .title="12.strike",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,2,2,0,0,0,0,1,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,6,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,10,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,23,7,8},
      {11,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas13_link = {
  .text=" bla#Ltarget#link#Lbla\r word",
  .title="13.link",
  .parse = {
    .err=TRUE,
    .nb_objs=8,
    .datas=&(short [8][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_LINK,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,13,2,0,0,0,0,0,0,0,1,0,0,0,0,0},
      {HOBJECT_TEXT,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,23,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,59,7,10},
      {24,0,23,7,8}
    },
    .nb_links=1,
    .dataslink=&(short [1][6]){
      {2,0,18,41,7,3}
    }
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas14_link2lines = {
  .text=" text#Ltarget#text\r text#Ltext",
  .title="14.link on 2 lines",
  .parse = {
    .err=TRUE,
    .nb_objs=8,
    .datas=&(short [8][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_LINK,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TEXT,14,2,0,0,0,0,0,0,0,1,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,19,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,20,2,0,0,0,0,0,0,0,1,0,0,0,0,0},
      {HOBJECT_TEXT,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,47,7,10},
      {20,0,47,7,10}
    },
    .nb_links=2,
    .dataslink=&(short [2][6]){
      {2,0,24,47,7,3},
      {2,1,0,23,7,3}
    }
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas15_align = {
  .text=" &Ccentered text\r &Lleft text\r &Rright text\r &Jsome text to draw on a page. This is very simple text without any formatting tags.",
  .title="15.aligned text",
  .parse = {
    .err=TRUE,
    .nb_objs=9,
    .datas=&(short [9][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_CENTER},
      {HOBJECT_TEXT,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,17,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,30,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_RIGHT},
      {HOBJECT_TEXT,33,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,44,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_JUSTIFIED},
      {HOBJECT_TEXT,47,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=7,
    .datas=&(short [7][5]){
      {3,0,77,7,8},
      {20,0,53,7,8},
      {33,0,59,7,8},
      {47,36,155,7,8},
      {73,30,155,7,8},
      {99,24,155,7,8},
      {125,0,23,7,8}
   },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas16_margin = {
  .text=" word\r &,word\r &;word\r &M005word\r &M100word\r &M250word\r &\\word",
  .title="16.margin",
  .parse = {
    .err=TRUE,
    .nb_objs=15,
    .datas=&(short [15][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,6,0,0,0,0,0,0,0,0,0,0,0,0,10,HALIGN_LEFT},
      {HOBJECT_TEXT,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,14,0,0,0,0,0,0,0,0,0,0,0,0,20,HALIGN_LEFT},
      {HOBJECT_TEXT,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,22,0,0,0,0,0,0,0,0,0,0,0,0,5,HALIGN_LEFT},
      {HOBJECT_TEXT,28,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,33,0,0,0,0,0,0,0,0,0,0,0,0,100,HALIGN_LEFT},
      {HOBJECT_TEXT,39,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,44,0,0,0,0,0,0,0,0,0,0,0,0,250,HALIGN_LEFT},
      {HOBJECT_TEXT,50,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,55,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,58,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=8,
    .datas=&(short [8][5]){
      {1,0,23,7,8},
      {9,0,23,7,8},
      {17,0,23,7,8},
      {28,0,23,7,8},
      {39,0,23,7,8},
      {50,0,17,7,8},
      {53,0,5,7,8},
      {58,0,23,7,8}
   },
    .nb_links=0,
    .dataslink=NULL
  }
};
/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas17_title = {
  .text=" \251TITLE=a title\r word",
  .title="17.title",
  .parse = {
    .err=TRUE,
    .nb_objs=3,
    .datas=&(short [3][16]){
      {HOBJECT_TIOS_LINE,16,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle="a title",
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=1,
    .datas=&(short [1][5]){
      {17,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas18_bkmk = {
  .text="\014bookmark\r word",
  .title="18.bkmk",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,10,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=1,
    .bkmks=&(short [1][2]){{0,0}}
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {1,0,47,7,8},
      {11,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas19_bkmktitle = {
  .text="\014&TMy bookmark&Tbkmk\r text",
  .title="19.bookmark title",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,21,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,22,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=1,
    .bkmks=&(short [1][2]){{3,0}}
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=2,
    .datas=&(short [2][5]){
      {16,0,23,7,8},
      {22,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas20_bkmklevels = {
  .text=" some text\r\014&T0title bk 1&Tbookmark!\r #3some text 1\r\014&T1title bk 1.1&Tsome text 1.1\r\014&T1title bk 1.2&Tsome text 1.2\r\014&T2title bk 1.2.1&Tsome text 1.2.1\r\014&T3title bk 1.2.1.1&Tsome text 1.2.1.1\r\014&T2title bk 1.2.2&Tsome text 1.2.2\r\014&Ttitle bk 2&Tsome text 2\r\014&T1title bk 2.1&Tsome text 2.1\r\014&T1title bk 2.3&Tsome text 2.3\r\014&T2title bk 2.3.1&Tsome text 2.3.1\r some text",
  .title="20.level bkmk text",
  .parse = {
    .err=TRUE,
    .nb_objs=27,
    .datas=&(short [27][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,11,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,27,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,37,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,38,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,52,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,70,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,84,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,102,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,116,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,136,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,152,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,174,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,192,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,212,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,228,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,243,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,255,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,273,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,287,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,305,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,319,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,339,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,355,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,356,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,365,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=10,
    .bkmks=&(short [10][2]){
      {15,0},
      {56,1},
      {88,1},
      {120,2},
      {156,3},
      {196,2},
      {231,0},
      {259,1},
      {291,1},
      {323,2}
    }
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=13,
    .datas=&(short [13][5]){
      {1,0,53,7,8},
      {27,0,53,7,8},
      {38,0,87,9,10},
      {70,0,103,9,10},
      {102,0,103,9,10},
      {136,0,119,9,10},
      {174,0,135,9,10},
      {212,0,119,9,10},
      {243,0,87,9,10},
      {273,0,103,9,10},
      {305,0,103,9,10},
      {339,0,119,9,10},
      {356,0,71,9,10}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas21_emptylines = {
  .text=" word\r \r \r ",
  .title="21.empty lines",
  .parse = {
    .err=TRUE,
    .nb_objs=9,
    .datas=&(short [9][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,6,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,7,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,8,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,10,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=4,
    .datas=&(short [4][5]){
      {1,0,23,7,8},
      {7,0,0,7,8},
      {9,0,0,7,8},
      {11,0,0,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas22_bigline = {
  .text=" aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r bbbbb",
  .title="22.big line",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,32,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,33,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {1,0,155,7,8},
      {27,0,23,7,8},
      {33,0,29,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas23_wwbigline = {
  .text=" #Waaaaaaaaaaaaaaaaaa aaaaaaaaaaaa\r bbbbb",
  .title="23.wordwarp big line",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,35,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,36,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {1,0,113,7,8},
      {22,0,71,7,8},
      {36,0,29,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas24_wwbiglinenospace = {
  .text=" #Waaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r bbbbb",
  .title="24.wordwarp big line nospace",
  .parse = {
    .err=TRUE,
    .nb_objs=5,
    .datas=&(short [5][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,34,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,35,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {1,0,155,7,8},
      {29,0,23,7,8},
      {35,0,29,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas25_pprint = {
  .text=" &E3x+1\r &Edfdf+++\r text",
  .title="25.pprint",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_PPRINT,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,8,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_PPRINT,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,19,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {3,0,36,10,10},
      {11,0,WIDTH_NO_PPRINT,HEIGHT_NO_PPRINT+2,HEIGHT_NO_PPRINT+2},
      {20,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas26_pic = {
  .text=" &Pmain\\picture\r &Pinvalid picture name\r text",
  .title="26.pic",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_PIC,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,16,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_PIC,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,40,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,41,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {3,0,8,10,10},
      {19,0,WIDTH_NO_PIC,HEIGHT_NO_PIC+2,HEIGHT_NO_PIC+2},
      {41,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas27_separat = {
  .text=" &-\r &=\r text",
  .title="27.separat",
  .parse = {
    .err=TRUE,
    .nb_objs=7,
    .datas=&(short [7][16]){
      {HOBJECT_TIOS_LINE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_SEPARAT1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,4,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_SEPARAT2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_TIOS_LINE,8,0,0,0,0,0,0,0,0,0,0,0,0,0,HALIGN_LEFT},
      {HOBJECT_TEXT,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {HOBJECT_END_TEXT,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=3,
    .datas=&(short [3][5]){
      {3,0,0,3,3},
      {7,0,0,5,5},
      {9,0,23,7,8}
    },
    .nb_links=0,
    .dataslink=NULL
  }
};
/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas28_text = {
  .text=" some text to draw on a page. This is very simple text without any formatting tags.",
  .title="28.simple text",
  .parse = {
    .err=TRUE,
    .nb_objs=0,
    .datas=NULL,
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=0,
    .datas=NULL,
    .nb_links=0,
    .dataslink=NULL
  }
};


/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas29_textfont = {
  .text=" #1some text to d#2ra#1w on a page. This is very simple text without any formatting tags.",
  .title="29.simple text & font",
  .parse = {
    .err=TRUE,
    .nb_objs=0,
    .datas=NULL,
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=0,
    .datas=NULL,
    .nb_links=0,
    .dataslink=NULL
  }
};



/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas30_textformat = {
  .text=" #1some #Utext#U to d#2ra#1w on a page. #VThis#V is very #2#Bsimp#ile#B text#i without any formatting tags.",
  .title="30.formatted text",
  .parse = {
    .err=TRUE,
    .nb_objs=0,
    .datas=NULL,
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=0,
    .datas=NULL,
    .nb_links=0,
    .dataslink=NULL
  }
};



/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas31_bigtext = {
  .text=" some text : line 1\r some text : line 2\r some text : line 3\r some text : line 4\r some text : line 5\r some text : line 6\r some text : line 7\r some text : line 8\r some text : line 9\r some text : line 10",
  .title="31.big text",
  .parse = {
    .err=TRUE,
    .nb_objs=0,
    .datas=NULL,
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=0,
    .datas=NULL,
    .nb_links=0,
    .dataslink=NULL
  }
};

/*===============================================================================================
== simple
===============================================================================================*/
TestDatas testdatas32_bigtextlink = {
  .text=" test link:\r #3a line\r a line : #Ltarget1#link 1#L\r a line\r a line\r a line\r a line\r a line\r a line\r a line : #Ltarget2#link 2#L\r a line\r a line\r a line : #Ltarget3#link 3#L\r a line : #Ltarget4#link 4#L--#Ltarget5#link 5#L\r a line\r a line : #Ltarget6#link 6#L\r a line\r a line\r a line\r a line\r a line\r a line",
  .title="32.links",
  .parse = {
    .err=TRUE,
    .nb_objs=0,
    .datas=NULL,
    .htitle=NULL,
    .hauthor=NULL,
    .hdate=NULL,
    .hcomment=NULL,
    .nb_bkmks=0,
    .bkmks=NULL
  },
  .layout = {
    .err=TRUE,
    .nb_scrlines=0,
    .datas=NULL,
    .nb_links=0,
    .dataslink=NULL
  }
};

