

#include "mktest.h"

/*===============================================================================================
== test
===============================================================================================*/

void test_drawmenu(const unsigned char * title, short nb_item, short nb_draw, short no_choice, short top,
  BOOL move, h_MenuLevel level_tab[5], h_FctDrawMenu draw_perso) {
  
  begintest("Draw menu",title);
  
  HANDLE htab=HeapAlloc(40);
  h_Font * fonttab = NULL;
  short nb_font = hl_loadAllFont(&fonttab);
  h_Menu hmenu = {
    .nb=nb_item,
    .size_item=7,
    .tab=NULL,
    .level_tab=level_tab,
    .font=hl_findFont("tios1",fonttab,nb_font),
    .pos_x=10,
    .pos_y=10,
    .width=50,
    .nb_draw=nb_draw,
    .no_choice=no_choice,
    .top=top,
    .move=move,
    .fct_draw=draw_perso,
    .draw_scrollbar = TRUE
  };
  hmenu.tab=HLock(htab);
  strcpy(hmenu.tab,"item1");
  strcpy(hmenu.tab+7,"item2");
  strcpy(hmenu.tab+14,"item3");
  strcpy(hmenu.tab+21,"item4");
  strcpy(hmenu.tab+28,"item5");

  clrscr();
  DrawStr(1,1,title,A_NORMAL);
  DrawLine(9,9,60,9,A_NORMAL);
  DrawLine(9,10+6*nb_draw,60,10+6*nb_draw,A_NORMAL);
  DrawLine(61,9,61,10+6*nb_draw,A_NORMAL);
  DrawLine(9,9,9,10+6*nb_draw,A_NORMAL);
  
  hl_drawMenu(&hmenu,LCD_SCREEN);
  
  ngetchx();

  HeapFree(htab);
  hl_unloadAllFont(fonttab,nb_font);

  finishtest();
}

/*===============================================================================================
== test
===============================================================================================*/
void test_drawmenu_perso1(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {
  short size_item=hmenu->size_item;
  if (size_item==0)
    size_item=sizeof(char *);
  hl_drawStr(hmenu->font,x,y,hmenu->tab+i*size_item,FALSE,FALSE,screen);
}

void test_drawmenu_perso2(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {
  unsigned char buffer[50];
  sprintf(buffer,"%d : %d,%d",i,x,y);
  hl_drawStr(hmenu->font,x,y,buffer,FALSE,FALSE,screen);
}

void test_menukey(const unsigned char * title, short nb_item, short nb_draw, short no_choice, short top,
  short newchoice, short newtop, void (* fcttest)(h_Menu * hmenu), h_MenuLevel level_tab[5]) {

  begintest("Menu key",title);
  
  h_Menu hmenu = {
    .nb=nb_item,
    .size_item=0,
    .tab=NULL,
    .level_tab=level_tab,
    .font=NULL,
    .pos_x=0,
    .pos_y=0,
    .width=0,
    .nb_draw=nb_draw,
    .no_choice=no_choice,
    .top=top,
    .move=FALSE,
    .fct_draw=NULL,
    .draw_scrollbar = TRUE
  };
  
  fcttest(&hmenu);
  testvalue("no_choice",hmenu.no_choice,newchoice);
  testvalue("top",hmenu.top,newtop);
  
  finishtest();

}




void test_drawmenuvat() {

  h_Menu hmenu;
  h_Font font1,font2,font3;
  HANDLE h;
  HANDLE h_level;
  short key;
  unsigned char name[20];

  hl_loadTiosFont(&font1,&font2,&font3);

  h_initMenuVAT(&hmenu,&font1,10,10,70,5,&h,&h_level,NULL,h_drawVAT);
  
  h_initSynchro(SPEED_KEY);
  
menu_redraw:
  hl_drawMenu(&hmenu,LCD_SCREEN);
  do {
    h_waitSynchro();
    key=0;
    if (K_DOWN) {
      h_startSynchro(SPEED_KEY);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(&hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(&hmenu);
      } else {
        hl_goMenuDown(&hmenu);
      }
      goto menu_redraw;
    } else if (K_UP) {
      h_startSynchro(SPEED_KEY);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(&hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(&hmenu);
      } else {
        hl_goMenuUp(&hmenu);
      }
      goto menu_redraw;
    } else if (K_ENTER) {  //[ENTER] : the choice is done
      h_startSynchro(SPEED_KEY);
      key=hmenu.no_choice+1;
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(SPEED_KEY);
      goto quit;
    } else {
      h_saveEnergy();
    }
  } while (key==0);

  SymCpy0(name,DerefSym(((HSym *)hmenu.tab)[key-1])->name);
  clrscr();
  printf("choose=%s\n",name);
  
  h_pause(SPEED_KEY);
quit: 
  h_waitSynchro()
  h_freeSynchro();
  
  HeapFree(h);
  HeapFree(h_level);

}
