
#include "mkhibliba.h"

/**
 * A reader which navigates by link.
 * 
 * @param hfile the file to read
 * @param hcfg the configuration
 * @param hlang the i18n texts
 * 
 * @return the number of the choosen link, NOK (-1) is none was choosen
 */
short h_chooseLink(h_File * hfile, h_Config * hcfg, h_I18nLink * hi18n) {

  /*static const unsigned char pic_pointer[] = {
    0b10000000,
    0b11000000,
    0b11100000,
    0b01110000,
    0b01111000,
    0b01111100,
    0b00111110,
    0b00111000,
    0b00101100,
    0b00000100,
    0b00000110,
    0b00000010
  };
  
  static const unsigned char mask_pointer[] = {
    0b00111111,
    0b00011111,
    0b00001111,
    0b00000111,
    0b00000011,
    0b00000001,
    0b10000000,
    0b10000001,
    0b10000001,
    0b11010001,
    0b11110000,
    0b11111000
  };*/
  
//  unsigned char pic_save[12*2];

  short no_link;
  short no_link2;
  short time = 0;
  h_LinkPos pos;
  BOOL flick_on = FALSE;
  short x1, x2, y1, y2;
  short height_font = hcfg->font_msg->upperline + hcfg->font_msg->underline;
  unsigned char buffer[20];

  hl_changeScreen(hfile, hfile->screen.mem.ptr, hfile->screen.pos.x, hfile->screen.pos.y, hfile->screen.size.width, hfile->screen.size.height - (height_font + 1));

  no_link = hl_getFirstLinkOfPage(hfile);

draw:
  if (flick_on) {
    hl_fillFrame(x1, y1, x2, y2, HGRAPHMODE_INVERSED, hfile->screen.mem);
  }
  
  hl_fillFrame(hfile->screen.pos.x, hfile->screen.pos.y + hfile->screen.size.height - 1, hfile->screen.pos.x + hfile->screen.size.width - 1, hfile->screen.pos.y + hfile->screen.size.height + height_font, HGRAPHMODE_WHITE, hfile->screen.mem);
  hl_drawLineHoriz(hfile->screen.pos.x, hfile->screen.pos.x + hfile->screen.size.width - 1, hfile->screen.pos.y + hfile->screen.size.height, HGRAPHMODE_BLACK, hfile->screen.mem);
  
  if (no_link == NOK) { //no link to show
    hl_drawStr(hcfg->font_msg, hfile->screen.pos.x, hfile->screen.pos.y + hfile->screen.size.height + 1, hi18n->no_link, FALSE, FALSE, hfile->screen.mem);
    x1 = -1;
    flick_on = FALSE;
  } else {
    if (hl_getTargetLink(buffer, no_link, hfile)) {
      hl_drawStr(hcfg->font_msg, hfile->screen.pos.x, hfile->screen.pos.y + hfile->screen.size.height + 1, buffer, FALSE, FALSE, hfile->screen.mem);
    } else {
      hl_drawStr(hcfg->font_msg, hfile->screen.pos.x, hfile->screen.pos.y + hfile->screen.size.height + 1, hi18n->bad_link, FALSE, FALSE, hfile->screen.mem);
    }
    pos = hl_getLinkPosition(no_link, hfile);
    x1 = pos.x1 + hfile->screen.pos.x;
    x2 = pos.x2 + hfile->screen.pos.x;
    y1 = pos.y1 + hfile->screen.pos.y;
    y2 = pos.y2 + hfile->screen.pos.y;
    time = 0;
    flick_on = FALSE;
  }

  while (TRUE) {
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {   //to the bottom
        hl_goLastPage(hfile);
        no_link = hl_getLastLinkOfPage(hfile);
      } else if (K_2ND) {  //by page
        no_link2 = no_link;
next_page:
        hl_goPageDown(hfile, PAGE_SCROLL_COMMON_BAND);
        flick_on = FALSE;
        no_link = hl_getFirstLinkOfPage(hfile);
        if (no_link != NOK && no_link < no_link2) {
          no_link = no_link2;
        }
      } else {
        no_link2 = no_link;
        no_link = hl_getNextLinkOfPage(no_link, hfile);
        if (no_link == NOK) {
          goto next_page;
        }
      }
      goto draw;
    } else if (K_UP) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {   //to the bottom
        hl_goFirstPage(hfile);
        no_link = hl_getFirstLinkOfPage(hfile);
      } else if (K_2ND) {  //by page
        no_link2 = no_link;
prev_page:
        hl_goPageUp(hfile, PAGE_SCROLL_COMMON_BAND);
        flick_on = FALSE;
        no_link = hl_getLastLinkOfPage(hfile);
        if (no_link != NOK && no_link > no_link2)
          no_link = no_link2;
      } else {
        no_link2 = no_link;
        no_link = hl_getPrevLinkOfPage(no_link, hfile);
        if (no_link == NOK) {
          goto prev_page;
        }
      }
      goto draw;
    } else if (K_ESC) {
      h_startSynchro(hcfg->speed_key);
      no_link = NOK;
      break;
    } else if (K_ENTER) {
      h_startSynchro(hcfg->speed_key);
      break;
    } else {
      h_saveEnergy();
    }
    if (x1 >= 0) {
      time++;
      if (flick_on) {
        if (time >= LINK_FLICKERING_TIME_ON) {
          hl_fillFrame(x1, y1, x2, y2, HGRAPHMODE_INVERSED, hfile->screen.mem);
          time = 0;
          flick_on = FALSE;
        }
      } else {
        if (time >= LINK_FLICKERING_TIME_OFF) {
          hl_fillFrame(x1, y1, x2, y2, HGRAPHMODE_INVERSED, hfile->screen.mem);
          time = 0;
          flick_on = TRUE;
        }
      }
    }
  }
      
  hl_changeScreen(hfile, hfile->screen.mem.ptr, hfile->screen.pos.x, hfile->screen.pos.y, hfile->screen.size.width, hfile->screen.size.height + (height_font + 1));
  
  return no_link;
}

