
#define USE_KERNEL
#include <tigcclib.h>
//#include "kernel.h"

#include "key.h"

#define TEST_HIBLIB

#include "hibtypes.h"
#include "hiblang.h"
#include "hiblib.h"
#include "hibliba.h"
#include "internal_types.h"

#define HEIGHT_TEST_BUFFER 100

typedef struct {
  BOOL err;
  short nb_objs;
  short (* datas)[][16];
  const unsigned char * htitle;
  const unsigned char * hauthor;
  const unsigned char * hdate;
  const unsigned char * hcomment;
  short nb_bkmks;
  short (* bkmks)[][2];
} TestParse;

typedef struct {
  BOOL err;
  short nb_scrlines;
  short (* datas)[][5];
  short nb_links;
  short (* dataslink)[][6];
} TestLayout;

typedef struct {
  const unsigned char * text;
  const unsigned char * title;
  TestParse parse;
  TestLayout layout;
} TestDatas;

/*===============================================================================================
== test parsing
===============================================================================================*/
extern void test_sizestruct(void);

/*===============================================================================================
== test parsing
===============================================================================================*/
extern void test_parse_header(const unsigned char * text, const unsigned char * title,
  BOOL returned_value,
  short pos_title,
  short pos_author,
  short pos_comment,
  short pos_date,
  short pos_txt,
  short pos_font[10]);
extern void test_parse_bkmk(const unsigned char * text, const unsigned char * title,
  BOOL returned_value,
  short study_pos_txt,
  short nb_bookmks,
  short bkmk_pos_txt,
  short level);
extern void test_parse_frtline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short margin,
  short align);
extern void test_parse_objline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short type,
  BOOL is_obj);
extern void test_parse_tiosline(const unsigned char * text, const unsigned char * title,
  short returned_value,
  short pos_txt,
  short nb_objs,
  short tabtest[][14]);
extern void test_parse_all(const unsigned char * text, const unsigned char * title,
  TestParse * testparse);


/*===============================================================================================
== test layout
===============================================================================================*/
extern void test_layout(const unsigned char * text, const unsigned char * title,
  TestLayout * testlayout);
  
  
/*===============================================================================================
== test font
===============================================================================================*/
extern void test_fontchar(const unsigned char * title, short x, short y, char character, short num_font, short size, BOOL italic, BOOL bold);
extern void test_fontstr(const unsigned char * title, short x, short y, const unsigned char * str, short num_font, short size, BOOL italic, BOOL bold);
extern void test_fontother(void);
extern void test_fontspeed(const unsigned char * title, short num_font,BOOL italic,BOOL bold);

/*===============================================================================================
== test utils
===============================================================================================*/  
extern void test_message(const unsigned char * title, const unsigned char * (tab_message[]), short nb);
extern void test_linehoriz(const unsigned char * title, short x1, short x2, short y, short length);
extern void test_linevert(const unsigned char * title, short x, short y1, short y2, short length);
extern void test_copyscreen_lcd(const unsigned char * title,
                     short dst_x, short dst_y, short dst_width, short dst_height, 
                     void * src, short src_x, short src_y, short src_width, short src_height, short src_byte_length);
extern void test_copyscreen_mem(const unsigned char * title,
                     short dst_x, short dst_y, short dst_width, short dst_height, short dst_byte_length, 
                     void * src, short src_x, short src_y, short src_width, short src_height, short src_byte_length);



/*===============================================================================================
== test draw
===============================================================================================*/
extern void test_drawline(const unsigned char * text, const unsigned char * title);
extern void test_drawpage(const unsigned char * text, const unsigned char * title,
              short width, short x, short y, short lcdwidth, short lcdheight);

/*===============================================================================================
== test datas
===============================================================================================*/
extern TestDatas testdatas01_simple;
extern TestDatas testdatas02_2lines;
extern TestDatas testdatas03_font;
extern TestDatas testdatas04_underline;
extern TestDatas testdatas05_dotted;
extern TestDatas testdatas06_vectconj;
extern TestDatas testdatas07_expsuffix;
extern TestDatas testdatas08_expsuffixfont;
extern TestDatas testdatas09_italic;
extern TestDatas testdatas10_bold;
extern TestDatas testdatas11_inversed;
extern TestDatas testdatas12_strike;
extern TestDatas testdatas13_link;
extern TestDatas testdatas14_link2lines;
extern TestDatas testdatas15_align;
extern TestDatas testdatas16_margin;
extern TestDatas testdatas17_title;
extern TestDatas testdatas18_bkmk;
extern TestDatas testdatas19_bkmktitle;
extern TestDatas testdatas20_bkmklevels;
extern TestDatas testdatas21_emptylines;
extern TestDatas testdatas22_bigline;
extern TestDatas testdatas23_wwbigline;
extern TestDatas testdatas24_wwbiglinenospace;
extern TestDatas testdatas25_pprint;
extern TestDatas testdatas26_pic;
extern TestDatas testdatas27_separat;
extern TestDatas testdatas28_text;
extern TestDatas testdatas29_textfont;
extern TestDatas testdatas30_textformat;
extern TestDatas testdatas31_bigtext;
extern TestDatas testdatas32_bigtextlink;

/*===============================================================================================
== test menu
===============================================================================================*/
extern void test_drawmenu(const unsigned char * title, short nb_item, short nb_draw, short no_choice, short top,
  BOOL move, h_MenuLevel level_tab[5], h_FctDrawMenu draw_perso);
extern void test_drawmenu_perso1(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen);
extern void test_drawmenu_perso2(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen);
extern void test_menukey(const unsigned char * title, short nb_item, short nb_draw, short no_choice, short top,
 short newchoice,  short newtop, void (* fcttest)(h_Menu * hmenu), h_MenuLevel level_tab[5]);
extern void test_drawmenuvat();

/*===============================================================================================
== test reader
===============================================================================================*/
extern void test_read(const unsigned char * text, const unsigned char * title, short width, short x, short y, short lcdwidth, short lcdheight);



/*===============================================================================================
== test reader
===============================================================================================*/
extern void test_link_nav(const unsigned char * title, h_Link * tablink, short nb_link,
      h_ScrLine * hscrlines, short line_top, short line_bot,
      short buffer_x, short buffer_y, short buffer_width, short buffer_height,
      short noline, short nolink_prev, short no_link_next,
      short searchlink, short prevlink, short nextlink, short firstlink, short lastlink);

extern void testmenuVAT(void);
extern void testmkhtxt(void);
extern void testreader(void);
extern void testdraw(void);


extern BOOL testvalue(const unsigned char * name_var, short calc_value, short wanted_value);
extern BOOL teststring(const unsigned char * name_var, const unsigned char * calc_string, const unsigned char * wanted_string);

extern void begintest(const unsigned char * main_name,const unsigned char * sub_name);
extern void finishtest(void);
