
#include "mkhibliba.h"

/**
 * Load a file with the HSym
 * It can open HTXT, TEXT, PIC and STR files
 *
 * @param hfile the h_File to fill
 * @param hsym the HSym of the file to load
 * @param line_width_max the maximum width of a lien of text (-1 for infinite)
 * @param fonttab the table of every font
 * @param nb_font the number of font
 * @param iscomp the function that return if a data is compressed or not
 * @param uncomp the function that uncompressed datas
 *
 * @return a h_Code saying it is successfull or not
 */
h_Code h_loadHSym(h_File * hfile, HSym hsym, short line_width_max, BOOL allowBigObject, h_Font * fonttab, short nb_font, FctIsComp iscomp, FctUnComp uncomp) {
  unsigned char * data;
  h_Code error = HCODE_NO_ERR;
  HANDLE h = H_NULL;
  HANDLE h_comp = H_NULL;
  const unsigned char * text;
  unsigned short size_text;
  short type;
  
  h = DerefSym(hsym)->handle;
    
  if (iscomp != NULL && uncomp != NULL) {
    type = iscomp(h);
    if (type != 0) {
      h_comp = h;
      h = uncomp(type, h);
      if (h == H_NULL) {
        return HCODE_ERR_MEM;
      }
    }
  }
  
  data = HLock(h);
  if (data == NULL) {
    error = HCODE_ERR_MEM;
    goto end;
  }
  
  switch (h_getFileType(data)) {
    case PIC_TAG: //it's a picture : create a little string
      data +=2;
      h_loadPic(hfile, h, (BITMAP *)data, iscomp, uncomp);
      goto end;
      break;
    case TEXT_TAG: //it's a text
      text = data + 4;
      size_text = *(unsigned short *)data - 1;
      break;
    case STR_TAG: //it's a string
      text = data + 2;
      size_text = *(unsigned short *)data - 1;
      break;
    default:
      error = HCODE_ERR_WRONG_TYPE;
      goto end;
  }

  if (!hl_parse(hfile, text, size_text)) {
    error = HCODE_ERR_MEM;
    goto end;
  }
  if (!hl_layout(hfile, line_width_max, allowBigObject, fonttab, nb_font, iscomp, uncomp)) {
    error = HCODE_ERR_MEM;
  } else {
    error = HCODE_NO_ERR;
  }
end:  
  if (h_comp != H_NULL) {
    HeapUnlock(h_comp);
    HeapFree(h);
  } else {
    HeapUnlock(h);
  }

  return error;
}
